/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.tcc;

import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionInterceptorHandler;
import io.seata.rm.tcc.remoting.RemotingDesc;
import io.seata.rm.tcc.remoting.parser.DubboUtil;
import io.seata.spring.util.SpringProxyUtils;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.Ordered;

public class TccActionInterceptor
implements MethodInterceptor,
ConfigurationChangeListener,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(TccActionInterceptor.class);
    private static final int ORDER_NUM = ConfigurationFactory.getInstance().getInt("client.rm.tccActionInterceptorOrder", -2147482648);
    private ActionInterceptorHandler actionInterceptorHandler = new ActionInterceptorHandler();
    private volatile boolean disable = ConfigurationFactory.getInstance().getBoolean("service.disableGlobalTransaction", false);
    protected RemotingDesc remotingDesc;

    public TccActionInterceptor() {
    }

    public TccActionInterceptor(RemotingDesc remotingDesc) {
        this.remotingDesc = remotingDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!RootContext.inGlobalTransaction() || this.disable || RootContext.inSagaBranch()) {
            return invocation.proceed();
        }
        Method method = this.getActionInterfaceMethod(invocation);
        TwoPhaseBusinessAction businessAction = method.getAnnotation(TwoPhaseBusinessAction.class);
        if (businessAction != null) {
            String xid = RootContext.getXID();
            BranchType previousBranchType = RootContext.getBranchType();
            if (BranchType.TCC != previousBranchType) {
                RootContext.bindBranchType((BranchType)BranchType.TCC);
            }
            try {
                Object object = this.actionInterceptorHandler.proceed(method, invocation.getArguments(), xid, businessAction, () -> ((MethodInvocation)invocation).proceed());
                return object;
            }
            finally {
                if (BranchType.TCC != previousBranchType) {
                    RootContext.unbindBranchType();
                }
                MDC.remove((String)"X-TX-BRANCH-ID");
            }
        }
        return invocation.proceed();
    }

    protected Method getActionInterfaceMethod(MethodInvocation invocation) {
        Class<?> serviceType = null;
        try {
            serviceType = this.remotingDesc == null ? this.getProxyInterface(invocation.getThis()) : this.remotingDesc.getServiceClass();
            if (serviceType == null && this.remotingDesc != null && this.remotingDesc.getServiceClassName() != null) {
                serviceType = Class.forName(this.remotingDesc.getServiceClassName(), true, Thread.currentThread().getContextClassLoader());
            }
            if (serviceType == null) {
                return invocation.getMethod();
            }
            return serviceType.getMethod(invocation.getMethod().getName(), invocation.getMethod().getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            if (serviceType != null && !"toString".equals(invocation.getMethod().getName())) {
                LOGGER.warn("no such method '{}' from interface {}", (Object)invocation.getMethod().getName(), (Object)serviceType.getName());
            }
            return invocation.getMethod();
        }
        catch (Exception e) {
            LOGGER.warn("get Method from interface failed", (Throwable)e);
            return invocation.getMethod();
        }
    }

    @Nullable
    protected Class<?> getProxyInterface(Object proxyBean) throws Exception {
        if (DubboUtil.isDubboProxyName((String)proxyBean.getClass().getName())) {
            return DubboUtil.getAssistInterface((Object)proxyBean);
        }
        return SpringProxyUtils.getTargetInterface(proxyBean);
    }

    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disable, event.getNewValue()});
            this.disable = Boolean.parseBoolean(event.getNewValue().trim());
        }
    }

    public int getOrder() {
        return ORDER_NUM;
    }
}

