/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.annotation.datasource;

import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.datasource.SeataDataSourceProxy;
import io.seata.spring.annotation.datasource.DataSourceProxyHolder;
import io.seata.spring.annotation.datasource.SeataProxy;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.IntroductionInfo;

public class SeataAutoDataSourceProxyAdvice
implements MethodInterceptor,
IntroductionInfo {
    private final BranchType branchType;
    private final Class<?>[] attachedInterfaces = new Class[]{SeataProxy.class};

    public SeataAutoDataSourceProxyAdvice(String dataSourceProxyMode) {
        this.branchType = BranchType.get((String)dataSourceProxyMode);
        RootContext.setDefaultBranchType((BranchType)this.branchType);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method declared;
        if (!this.inExpectedContext()) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        String name = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        try {
            declared = DataSource.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return invocation.proceed();
        }
        DataSource origin = (DataSource)invocation.getThis();
        SeataDataSourceProxy proxy = DataSourceProxyHolder.get(origin);
        Object[] args = invocation.getArguments();
        return declared.invoke((Object)proxy, args);
    }

    public Class<?>[] getInterfaces() {
        return this.attachedInterfaces;
    }

    boolean inExpectedContext() {
        if (RootContext.requireGlobalLock()) {
            return true;
        }
        if (!RootContext.inGlobalTransaction()) {
            return false;
        }
        return this.branchType == RootContext.getBranchType();
    }
}

