/*
 * Decompiled with CFR 0.152.
 */
package io.seata.spring.boot.autoconfigure;

import io.seata.spring.boot.autoconfigure.StarterConstants;
import io.seata.spring.boot.autoconfigure.properties.server.MetricsProperties;
import io.seata.spring.boot.autoconfigure.properties.server.ServerProperties;
import io.seata.spring.boot.autoconfigure.properties.server.ServerRecoveryProperties;
import io.seata.spring.boot.autoconfigure.properties.server.ServerUndoProperties;
import io.seata.spring.boot.autoconfigure.properties.server.session.SessionProperties;
import io.seata.spring.boot.autoconfigure.properties.server.store.StoreDBProperties;
import io.seata.spring.boot.autoconfigure.properties.server.store.StoreFileProperties;
import io.seata.spring.boot.autoconfigure.properties.server.store.StoreProperties;
import io.seata.spring.boot.autoconfigure.properties.server.store.StoreRedisProperties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class SeataServerEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final AtomicBoolean INIT = new AtomicBoolean(false);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        SeataServerEnvironmentPostProcessor.init();
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public static void init() {
        if (INIT.compareAndSet(false, true)) {
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server", ServerProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.undo", ServerUndoProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.recovery", ServerRecoveryProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.metrics", MetricsProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store", StoreProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.session", StoreProperties.Session.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.lock", StoreProperties.Lock.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.file", StoreFileProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.db", StoreDBProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis", StoreRedisProperties.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis.single", StoreRedisProperties.Single.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.store.redis.sentinel", StoreRedisProperties.Sentinel.class);
            StarterConstants.PROPERTY_BEAN_MAP.put("seata.server.session", SessionProperties.class);
        }
    }
}

