/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.utils;

import io.seata.saga.engine.AsyncCallback;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.StateMachineEngine;
import io.seata.saga.proctrl.Instruction;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessType;
import io.seata.saga.proctrl.impl.ProcessContextImpl;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachineInstance;
import java.util.Map;

public class ProcessContextBuilder {
    private ProcessContextImpl processContext = new ProcessContextImpl();

    private ProcessContextBuilder() {
    }

    public static ProcessContextBuilder create() {
        return new ProcessContextBuilder();
    }

    public ProcessContext build() {
        return this.processContext;
    }

    public ProcessContextBuilder withProcessType(ProcessType processType) {
        if (processType != null) {
            this.processContext.setVariable("_ProcessType_", (Object)processType);
        }
        return this;
    }

    public ProcessContextBuilder withAsyncCallback(AsyncCallback asyncCallback) {
        if (asyncCallback != null) {
            this.processContext.setVariable("_async_callback_", (Object)asyncCallback);
        }
        return this;
    }

    public ProcessContextBuilder withInstruction(Instruction instruction) {
        if (instruction != null) {
            this.processContext.setInstruction(instruction);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineInstance(StateMachineInstance stateMachineInstance) {
        if (stateMachineInstance != null) {
            this.processContext.setVariable("_current_statemachine_instance_", (Object)stateMachineInstance);
            this.processContext.setVariable("_current_statemachine_", (Object)stateMachineInstance.getStateMachine());
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineEngine(StateMachineEngine stateMachineEngine) {
        if (stateMachineEngine != null) {
            this.processContext.setVariable("_current_statemachine_engine_", (Object)stateMachineEngine);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineConfig(StateMachineConfig stateMachineConfig) {
        if (stateMachineConfig != null) {
            this.processContext.setVariable("_statemachine_config_", (Object)stateMachineConfig);
        }
        return this;
    }

    public ProcessContextBuilder withStateMachineContextVariables(Map<String, Object> contextVariables) {
        if (contextVariables != null) {
            this.processContext.setVariable("context", contextVariables);
        }
        return this;
    }

    public ProcessContextBuilder withOperationName(String operationName) {
        if (operationName != null) {
            this.processContext.setVariable("_operation_name_", (Object)operationName);
        }
        return this;
    }

    public ProcessContextBuilder withStateInstance(StateInstance stateInstance) {
        if (stateInstance != null) {
            this.processContext.setVariable("_current_state_instance_", (Object)stateInstance);
        }
        return this;
    }

    public ProcessContextBuilder withIsAsyncExecution(boolean isAsyncExecution) {
        this.processContext.setVariable("_is_async_execution_", (Object)isAsyncExecution);
        return this;
    }
}

