/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext;

import io.seata.common.exception.FrameworkException;
import io.seata.common.util.CollectionUtils;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.pcext.InterceptableStateRouter;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.StateRouter;
import io.seata.saga.engine.pcext.StateRouterInterceptor;
import io.seata.saga.engine.pcext.routers.EndStateRouter;
import io.seata.saga.engine.pcext.routers.TaskStateRouter;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.proctrl.Instruction;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessRouter;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateMachine;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class StateMachineProcessRouter
implements ProcessRouter {
    private final Map<String, StateRouter> stateRouters = new ConcurrentHashMap<String, StateRouter>();

    public Instruction route(ProcessContext context) throws FrameworkException {
        State state;
        StateInstruction stateInstruction = (StateInstruction)context.getInstruction(StateInstruction.class);
        if (stateInstruction.getTemporaryState() != null) {
            state = stateInstruction.getTemporaryState();
            stateInstruction.setTemporaryState(null);
        } else {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            StateMachine stateMachine = stateMachineConfig.getStateMachineRepository().getStateMachine(stateInstruction.getStateMachineName(), stateInstruction.getTenantId());
            state = (State)stateMachine.getStates().get(stateInstruction.getStateName());
        }
        String stateType = state.getType();
        StateRouter router = this.stateRouters.get(stateType);
        Instruction instruction = null;
        List<StateRouterInterceptor> interceptors = null;
        if (router instanceof InterceptableStateRouter) {
            interceptors = ((InterceptableStateRouter)router).getInterceptors();
        }
        ArrayList<StateRouterInterceptor> executedInterceptors = null;
        Exception exception = null;
        try {
            if (CollectionUtils.isNotEmpty(interceptors)) {
                executedInterceptors = new ArrayList<StateRouterInterceptor>(interceptors.size());
                for (StateRouterInterceptor interceptor : interceptors) {
                    executedInterceptors.add(interceptor);
                    interceptor.preRoute(context, state);
                }
            }
            instruction = router.route(context, state);
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            if (CollectionUtils.isNotEmpty(executedInterceptors)) {
                for (int i = executedInterceptors.size() - 1; i >= 0; --i) {
                    StateRouterInterceptor interceptor = (StateRouterInterceptor)executedInterceptors.get(i);
                    interceptor.postRoute(context, state, instruction, exception);
                }
            }
            if (instruction == null && !stateInstruction.isEnd()) {
                EngineUtils.endStateMachine(context);
            }
        }
        return instruction;
    }

    public void initDefaultStateRouters() {
        if (this.stateRouters.isEmpty()) {
            TaskStateRouter taskStateRouter = new TaskStateRouter();
            this.stateRouters.put("ServiceTask", taskStateRouter);
            this.stateRouters.put("ScriptTask", taskStateRouter);
            this.stateRouters.put("Choice", taskStateRouter);
            this.stateRouters.put("CompensationTrigger", taskStateRouter);
            this.stateRouters.put("SubStateMachine", taskStateRouter);
            this.stateRouters.put("CompensateSubMachine", taskStateRouter);
            this.stateRouters.put("LoopStart", taskStateRouter);
            this.stateRouters.put("Succeed", new EndStateRouter());
            this.stateRouters.put("Fail", new EndStateRouter());
        }
    }

    public Map<String, StateRouter> getStateRouters() {
        return this.stateRouters;
    }

    public void setStateRouters(Map<String, StateRouter> stateRouters) {
        this.stateRouters.putAll(stateRouters);
    }
}

