/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.store.db;

import io.seata.common.exception.StoreException;
import io.seata.common.util.BeanUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractStore {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractStore.class);
    protected DataSource dataSource;
    protected String dbType;
    protected String tablePrefix;

    public static void closeSilent(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected <T> T selectOne(String sql, ResultSetToObject<T> resultSetToObject, Object ... args) {
        ResultSet resultSet;
        PreparedStatement stmt;
        Connection connection;
        block7: {
            T i2;
            connection = null;
            stmt = null;
            resultSet = null;
            try {
                connection = this.dataSource.getConnection();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Preparing SQL statement: {}", (Object)sql);
                }
                stmt = connection.prepareStatement(sql);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("setting params to PreparedStatement: {}", (Object)Arrays.toString(args));
                }
                for (int i2 = 0; i2 < args.length; ++i2) {
                    stmt.setObject(i2 + 1, args[i2]);
                }
                resultSet = stmt.executeQuery();
                if (!resultSet.next()) break block7;
                i2 = resultSetToObject.toObject(resultSet);
            }
            catch (SQLException e) {
                try {
                    throw new StoreException((Throwable)e);
                }
                catch (Throwable throwable) {
                    AbstractStore.closeSilent(resultSet);
                    AbstractStore.closeSilent(stmt);
                    AbstractStore.closeSilent(connection);
                    throw throwable;
                }
            }
            AbstractStore.closeSilent(resultSet);
            AbstractStore.closeSilent(stmt);
            AbstractStore.closeSilent(connection);
            return i2;
        }
        AbstractStore.closeSilent(resultSet);
        AbstractStore.closeSilent(stmt);
        AbstractStore.closeSilent(connection);
        return null;
    }

    protected <T> List<T> selectList(String sql, ResultSetToObject<T> resultSetToObject, Object ... args) {
        ArrayList<T> arrayList;
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet resultSet = null;
        try {
            connection = this.dataSource.getConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Preparing SQL: {}", (Object)sql);
            }
            stmt = connection.prepareStatement(sql);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setting params to PreparedStatement: {}", (Object)Arrays.toString(args));
            }
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            resultSet = stmt.executeQuery();
            ArrayList<T> list = new ArrayList<T>();
            while (resultSet.next()) {
                list.add(resultSetToObject.toObject(resultSet));
            }
            arrayList = list;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                AbstractStore.closeSilent(resultSet);
                AbstractStore.closeSilent(stmt);
                AbstractStore.closeSilent(connection);
                throw throwable;
            }
        }
        AbstractStore.closeSilent(resultSet);
        AbstractStore.closeSilent(stmt);
        AbstractStore.closeSilent(connection);
        return arrayList;
    }

    protected <T> int executeUpdate(String sql, ObjectToStatement<T> objectToStatement, T o) {
        int n;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.dataSource.getConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Preparing SQL: {}", (Object)sql);
            }
            stmt = connection.prepareStatement(sql);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setting params to PreparedStatement: {}", (Object)BeanUtils.beanToString(o));
            }
            objectToStatement.toStatement(o, stmt);
            int count = stmt.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            n = count;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                AbstractStore.closeSilent(stmt);
                AbstractStore.closeSilent(connection);
                throw throwable;
            }
        }
        AbstractStore.closeSilent(stmt);
        AbstractStore.closeSilent(connection);
        return n;
    }

    protected int executeUpdate(String sql, Object ... args) {
        int n;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.dataSource.getConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Preparing SQL: {}", (Object)sql);
            }
            stmt = connection.prepareStatement(sql);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setting params to PreparedStatement: {}", (Object)Arrays.toString(args));
            }
            for (int i = 0; i < args.length; ++i) {
                stmt.setObject(i + 1, args[i]);
            }
            int count = stmt.executeUpdate();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            n = count;
        }
        catch (SQLException e) {
            try {
                throw new StoreException((Throwable)e);
            }
            catch (Throwable throwable) {
                AbstractStore.closeSilent(stmt);
                AbstractStore.closeSilent(connection);
                throw throwable;
            }
        }
        AbstractStore.closeSilent(stmt);
        AbstractStore.closeSilent(connection);
        return n;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    protected static interface ResultSetToObject<T> {
        public T toObject(ResultSet var1) throws SQLException;
    }

    protected static interface ObjectToStatement<T> {
        public void toStatement(T var1, PreparedStatement var2) throws SQLException;
    }
}

