/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.IOUtil;
import io.seata.common.util.StringUtils;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationFactory;
import io.seata.rm.datasource.SqlGenerateUtils;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.AbstractDMLBaseExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.rm.datasource.sql.struct.TableMeta;
import io.seata.rm.datasource.sql.struct.TableRecords;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLUpdateRecognizer;
import io.seata.sqlparser.WhereRecognizer;
import io.seata.sqlparser.util.ColumnUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

public class MultiUpdateExecutor<T, S extends Statement>
extends AbstractDMLBaseExecutor<T, S> {
    private static final Configuration CONFIG = ConfigurationFactory.getInstance();
    private static final boolean ONLY_CARE_UPDATE_COLUMNS = CONFIG.getBoolean("client.undo.onlyCareUpdateColumns", true);

    public MultiUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    protected TableRecords beforeImage() throws SQLException {
        if (this.sqlRecognizers.size() == 1) {
            UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
            return executor.beforeImage();
        }
        TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
        ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
        HashSet updateColumnsSet = new HashSet();
        StringBuilder whereCondition = new StringBuilder();
        boolean noWhereCondition = false;
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)recognizer;
            if (StringUtils.isNotBlank((String)sqlUpdateRecognizer.getLimitCondition())) {
                throw new NotSupportYetException("Multi update SQL with limit condition is not support yet !");
            }
            if (StringUtils.isNotBlank((String)sqlUpdateRecognizer.getOrderByCondition())) {
                throw new NotSupportYetException("Multi update SQL with orderBy condition is not support yet !");
            }
            List updateColumns = sqlUpdateRecognizer.getUpdateColumnsIsSimplified();
            updateColumnsSet.addAll(updateColumns);
            if (noWhereCondition) continue;
            String whereConditionStr = this.buildWhereCondition((WhereRecognizer)sqlUpdateRecognizer, paramAppenderList);
            if (StringUtils.isBlank((String)whereConditionStr)) {
                noWhereCondition = true;
                continue;
            }
            if (whereCondition.length() > 0) {
                whereCondition.append(" OR ");
            }
            whereCondition.append(whereConditionStr);
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        StringBuilder suffix = new StringBuilder(" FROM ").append(this.getFromTableInSQL());
        if (noWhereCondition) {
            paramAppenderList.clear();
        } else {
            suffix.append(" WHERE ").append((CharSequence)whereCondition);
        }
        suffix.append(" FOR UPDATE");
        StringJoiner selectSQLAppender = new StringJoiner(", ", prefix, suffix.toString());
        if (ONLY_CARE_UPDATE_COLUMNS) {
            if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
                selectSQLAppender.add(this.getColumnNamesInSQL(tmeta.getEscapePkNameList(this.getDbType())));
            }
            for (String updateCol : updateColumnsSet) {
                selectSQLAppender.add(updateCol);
            }
        } else {
            for (String columnName : tmeta.getAllColumns().keySet()) {
                selectSQLAppender.add(ColumnUtils.addEscape((String)columnName, (String)this.getDbType()));
            }
        }
        return this.buildTableRecords(tmeta, selectSQLAppender.toString(), paramAppenderList);
    }

    /*
     * Loose catch block
     */
    @Override
    protected TableRecords afterImage(TableRecords beforeImage) throws SQLException {
        TableRecords tableRecords;
        PreparedStatement pst;
        ResultSet rs;
        block10: {
            if (this.sqlRecognizers.size() == 1) {
                UpdateExecutor executor = new UpdateExecutor(this.statementProxy, this.statementCallback, (SQLRecognizer)this.sqlRecognizers.get(0));
                return executor.afterImage(beforeImage);
            }
            if (beforeImage == null || beforeImage.size() == 0) {
                return TableRecords.empty(this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName()));
            }
            TableMeta tmeta = this.getTableMeta(((SQLRecognizer)this.sqlRecognizers.get(0)).getTableName());
            String selectSQL = this.buildAfterImageSQL(tmeta, beforeImage);
            rs = null;
            pst = this.statementProxy.getConnection().prepareStatement(selectSQL);
            SqlGenerateUtils.setParamForPk(beforeImage.pkRows(), this.getTableMeta().getPrimaryKeyOnlyName(), pst);
            rs = pst.executeQuery();
            tableRecords = TableRecords.buildRecords(tmeta, rs);
            if (pst == null) break block10;
            pst.close();
        }
        IOUtil.close((AutoCloseable)rs);
        return tableRecords;
        {
            catch (Throwable throwable) {
                try {
                    if (pst != null) {
                        try {
                            pst.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    IOUtil.close(rs);
                    throw throwable3;
                }
            }
        }
    }

    private String buildAfterImageSQL(TableMeta tableMeta, TableRecords beforeImage) throws SQLException {
        HashSet updateColumnsSet = new HashSet();
        Iterator iterator = this.sqlRecognizers.iterator();
        while (iterator.hasNext()) {
            SQLRecognizer recognizer;
            this.sqlRecognizer = recognizer = (SQLRecognizer)iterator.next();
            SQLUpdateRecognizer sqlUpdateRecognizer = (SQLUpdateRecognizer)this.sqlRecognizer;
            updateColumnsSet.addAll(sqlUpdateRecognizer.getUpdateColumnsIsSimplified());
        }
        StringBuilder prefix = new StringBuilder("SELECT ");
        String suffix = " FROM " + this.getFromTableInSQL() + " WHERE " + SqlGenerateUtils.buildWhereConditionByPKs(tableMeta.getPrimaryKeyOnlyName(), beforeImage.pkRows().size(), this.getDbType());
        StringJoiner selectSQLJoiner = new StringJoiner(", ", prefix.toString(), suffix);
        if (ONLY_CARE_UPDATE_COLUMNS) {
            if (!this.containsPK(new ArrayList<String>(updateColumnsSet))) {
                selectSQLJoiner.add(this.getColumnNamesInSQL(tableMeta.getEscapePkNameList(this.getDbType())));
            }
            for (String updateCol : updateColumnsSet) {
                selectSQLJoiner.add(updateCol);
            }
        } else {
            for (String columnName : tableMeta.getAllColumns().keySet()) {
                selectSQLJoiner.add(ColumnUtils.addEscape((String)columnName, (String)this.getDbType()));
            }
        }
        return selectSQLJoiner.toString();
    }
}

