/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.statelang.parser.utils;

import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public class ResourceUtil {
    private static final ResourcePatternResolver RESOURCE_RESOLVER = new PathMatchingResourcePatternResolver();

    public static Resource[] getResources(String location) {
        try {
            return RESOURCE_RESOLVER.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public static Resource[] getResources(String[] locationArr) {
        return (Resource[])Stream.of(Optional.ofNullable(locationArr).orElse(new String[0])).flatMap(location -> Stream.of(ResourceUtil.getResources(location))).toArray(Resource[]::new);
    }
}

