/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.utils;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NumberUtils;
import io.seata.common.util.StringUtils;
import io.seata.saga.engine.StateMachineConfig;
import io.seata.saga.engine.evaluation.expression.ExpressionEvaluator;
import io.seata.saga.engine.exception.ForwardInvalidException;
import io.seata.saga.engine.pcext.StateInstruction;
import io.seata.saga.engine.pcext.utils.EngineUtils;
import io.seata.saga.engine.pcext.utils.LoopContextHolder;
import io.seata.saga.engine.pcext.utils.ParameterUtils;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.impl.ProcessContextImpl;
import io.seata.saga.statelang.domain.ExecutionStatus;
import io.seata.saga.statelang.domain.State;
import io.seata.saga.statelang.domain.StateInstance;
import io.seata.saga.statelang.domain.StateMachine;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.saga.statelang.domain.TaskState;
import io.seata.saga.statelang.domain.impl.AbstractTaskState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopTaskUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoopTaskUtils.class);
    private static final String DEFAULT_COMPLETION_CONDITION = "[nrOfInstances] == [nrOfCompletedInstances]";
    public static final String LOOP_STATE_NAME_PATTERN = "-loop-";
    private static final Map<String, ExpressionEvaluator> EXPRESSION_EVALUATOR_MAP = new ConcurrentHashMap<String, ExpressionEvaluator>();

    public static TaskState.Loop getLoopConfig(ProcessContext context, State currentState) {
        if (LoopTaskUtils.matchLoop(currentState)) {
            AbstractTaskState taskState = (AbstractTaskState)currentState;
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            if (null != taskState.getLoop()) {
                Object expression;
                Object collection;
                TaskState.Loop loop = taskState.getLoop();
                String collectionName = loop.getCollection();
                if (StringUtils.isNotBlank(collectionName) && (collection = ParameterUtils.getValue(expression = ParameterUtils.createValueExpression(stateMachineConfig.getExpressionFactoryManager(), collectionName), stateMachineInstance.getContext(), null)) instanceof Collection && ((Collection)collection).size() > 0) {
                    LoopContextHolder.getCurrent(context, true).setCollection((Collection)collection);
                    return loop;
                }
                LOGGER.warn("State [{}] loop collection param [{}] invalid", (Object)currentState.getName(), (Object)collectionName);
            }
        }
        return null;
    }

    public static boolean matchLoop(State state) {
        return state != null && ("ServiceTask".equals(state.getType()) || "ScriptTask".equals(state.getType()) || "SubStateMachine".equals(state.getType()));
    }

    public static void createLoopCounterContext(ProcessContext context) {
        LoopContextHolder contextHolder = LoopContextHolder.getCurrent(context, true);
        Collection collection = contextHolder.getCollection();
        contextHolder.getNrOfInstances().set(collection.size());
        for (int i = collection.size() - 1; i >= 0; --i) {
            contextHolder.getLoopCounterStack().push(i);
        }
    }

    public static void reloadLoopContext(ProcessContext context, String forwardStateName) {
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        List<StateInstance> actList = stateMachineInstance.getStateList();
        List forwardStateList = actList.stream().filter(e -> forwardStateName.equals(EngineUtils.getOriginStateName(e))).collect(Collectors.toList());
        LoopContextHolder loopContextHolder = LoopContextHolder.getCurrent(context, true);
        Collection collection = loopContextHolder.getCollection();
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            list.addFirst(i);
        }
        int executedNumber = 0;
        LinkedList<Integer> failEndList = new LinkedList<Integer>();
        for (StateInstance stateInstance : forwardStateList) {
            if (stateInstance.isIgnoreStatus()) continue;
            if (ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) {
                ++executedNumber;
            } else {
                stateInstance.setIgnoreStatus(true);
                failEndList.addFirst(LoopTaskUtils.reloadLoopCounter(stateInstance.getName()));
            }
            list.remove((Object)LoopTaskUtils.reloadLoopCounter(stateInstance.getName()));
        }
        loopContextHolder.getLoopCounterStack().addAll(list);
        loopContextHolder.getForwardCounterStack().addAll(failEndList);
        loopContextHolder.getNrOfInstances().set(collection.size());
        loopContextHolder.getNrOfCompletedInstances().set(executedNumber);
    }

    public static ProcessContext createLoopEventContext(ProcessContext context, int loopCounter) {
        ProcessContextImpl copyContext = new ProcessContextImpl();
        copyContext.setParent(context);
        copyContext.setVariableLocally("loopCounter", loopCounter >= 0 ? loopCounter : LoopTaskUtils.acquireNextLoopCounter(context));
        copyContext.setInstruction(LoopTaskUtils.copyInstruction(context.getInstruction(StateInstruction.class)));
        return copyContext;
    }

    public static StateInstance findOutLastNeedForwardStateInstance(ProcessContext context) {
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateInstance lastForwardState = (StateInstance)context.getVariable("_current_state_instance_");
        List<StateInstance> actList = stateMachineInstance.getStateList();
        for (int i = actList.size() - 1; i >= 0; --i) {
            StateInstance stateInstance = actList.get(i);
            if (!EngineUtils.getOriginStateName(stateInstance).equals(EngineUtils.getOriginStateName(lastForwardState)) || ExecutionStatus.SU.equals((Object)stateInstance.getStatus())) continue;
            return stateInstance;
        }
        return lastForwardState;
    }

    public static StateInstance findOutLastRetriedStateInstance(StateMachineInstance stateMachineInstance, String stateName) {
        List<StateInstance> actList = stateMachineInstance.getStateList();
        for (int i = actList.size() - 1; i >= 0; --i) {
            StateInstance stateInstance = actList.get(i);
            if (!stateInstance.getName().equals(stateName)) continue;
            return stateInstance;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCompletionConditionSatisfied(ProcessContext context) {
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        AbstractTaskState currentState = (AbstractTaskState)instruction.getState(context);
        LoopContextHolder currentLoopContext = LoopContextHolder.getCurrent(context, true);
        if (currentLoopContext.isCompletionConditionSatisfied()) {
            return true;
        }
        int nrOfInstances = currentLoopContext.getNrOfInstances().get();
        int nrOfActiveInstances = currentLoopContext.getNrOfActiveInstances().get();
        int nrOfCompletedInstances = currentLoopContext.getNrOfCompletedInstances().get();
        if (!currentLoopContext.isCompletionConditionSatisfied()) {
            LoopContextHolder loopContextHolder = currentLoopContext;
            synchronized (loopContextHolder) {
                if (!currentLoopContext.isCompletionConditionSatisfied()) {
                    Map stateMachineContext = (Map)context.getVariable("context");
                    stateMachineContext.put("nrOfInstances", Double.valueOf(nrOfInstances));
                    stateMachineContext.put("nrOfActiveInstances", Double.valueOf(nrOfActiveInstances));
                    stateMachineContext.put("nrOfCompletedInstances", Double.valueOf(nrOfCompletedInstances));
                    if (nrOfCompletedInstances >= nrOfInstances || LoopTaskUtils.getEvaluator(context, currentState.getLoop().getCompletionCondition()).evaluate(stateMachineContext)) {
                        currentLoopContext.setCompletionConditionSatisfied(true);
                    }
                }
            }
        }
        return currentLoopContext.isCompletionConditionSatisfied();
    }

    public static int acquireNextLoopCounter(ProcessContext context) {
        try {
            return LoopContextHolder.getCurrent(context, true).getLoopCounterStack().pop();
        }
        catch (EmptyStackException e) {
            return -1;
        }
    }

    public static String generateLoopStateName(ProcessContext context, String stateName) {
        if (StringUtils.isNotBlank(stateName)) {
            int loopCounter = (Integer)context.getVariable("loopCounter");
            return stateName + LOOP_STATE_NAME_PATTERN + loopCounter;
        }
        return stateName;
    }

    public static int reloadLoopCounter(String stateName) {
        int end;
        if (StringUtils.isNotBlank(stateName) && (end = stateName.lastIndexOf(LOOP_STATE_NAME_PATTERN)) > -1) {
            String loopCounter = stateName.substring(end + LOOP_STATE_NAME_PATTERN.length());
            return NumberUtils.toInt(loopCounter, -1);
        }
        return -1;
    }

    public static void putContextToParent(ProcessContext context, List<ProcessContext> subContextList, State state) {
        Map contextVariables = (Map)context.getVariable("context");
        if (CollectionUtils.isNotEmpty(subContextList)) {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            ArrayList<Map<String, Object>> subContextVariables = new ArrayList<Map<String, Object>>();
            for (ProcessContext subProcessContext : subContextList) {
                StateInstance stateInstance = (StateInstance)subProcessContext.getVariable("_current_state_instance_");
                Map<String, Object> outputVariablesToContext = ParameterUtils.createOutputParams(stateMachineConfig.getExpressionFactoryManager(), (AbstractTaskState)state, stateInstance.getOutputParams());
                subContextVariables.add(outputVariablesToContext);
            }
            contextVariables.put("loopResult", subContextVariables);
        }
    }

    public static boolean isForSubStateMachineForward(ProcessContext context) {
        StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
        StateInstruction instruction = context.getInstruction(StateInstruction.class);
        StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
        StateInstance lastRetriedStateInstance = LoopTaskUtils.findOutLastRetriedStateInstance(stateMachineInstance, LoopTaskUtils.generateLoopStateName(context, instruction.getStateName()));
        if (null != lastRetriedStateInstance && "SubStateMachine".equals(lastRetriedStateInstance.getType()) && !ExecutionStatus.SU.equals((Object)lastRetriedStateInstance.getCompensationStatus())) {
            while (StringUtils.isNotBlank(lastRetriedStateInstance.getStateIdRetriedFor())) {
                lastRetriedStateInstance = stateMachineConfig.getStateLogStore().getStateInstance(lastRetriedStateInstance.getStateIdRetriedFor(), lastRetriedStateInstance.getMachineInstanceId());
            }
            List<StateMachineInstance> subInst = stateMachineConfig.getStateLogStore().queryStateMachineInstanceByParentId(EngineUtils.generateParentId(lastRetriedStateInstance));
            if (CollectionUtils.isNotEmpty(subInst) && ExecutionStatus.SU.equals((Object)subInst.get(0).getCompensationStatus())) {
                return false;
            }
            if (ExecutionStatus.UN.equals((Object)subInst.get(0).getCompensationStatus())) {
                throw new ForwardInvalidException("Last forward execution state instance is SubStateMachine and compensation status is [UN], Operation[forward] denied, stateInstanceId:" + lastRetriedStateInstance.getId(), FrameworkErrorCode.OperationDenied);
            }
            return true;
        }
        return false;
    }

    public static String decideCurrentExceptionRoute(List<ProcessContext> subContextList, StateMachine stateMachine) {
        String route = null;
        if (CollectionUtils.isNotEmpty(subContextList)) {
            for (ProcessContext processContext : subContextList) {
                String next = (String)processContext.getVariable("_current_exception_route_");
                if (!StringUtils.isNotBlank(next)) continue;
                State state = stateMachine.getState(next);
                if ("CompensationTrigger".equals(state.getType())) {
                    route = next;
                    break;
                }
                if (null != route) continue;
                route = next;
            }
        }
        return route;
    }

    private static ExpressionEvaluator getEvaluator(ProcessContext context, String completionCondition) {
        if (StringUtils.isBlank(completionCondition)) {
            completionCondition = DEFAULT_COMPLETION_CONDITION;
        }
        if (!EXPRESSION_EVALUATOR_MAP.containsKey(completionCondition)) {
            StateMachineConfig stateMachineConfig = (StateMachineConfig)context.getVariable("_statemachine_config_");
            ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)stateMachineConfig.getEvaluatorFactoryManager().getEvaluatorFactory("Default").createEvaluator(completionCondition);
            expressionEvaluator.setRootObjectName(null);
            EXPRESSION_EVALUATOR_MAP.put(completionCondition, expressionEvaluator);
        }
        return EXPRESSION_EVALUATOR_MAP.get(completionCondition);
    }

    private static StateInstruction copyInstruction(StateInstruction instruction) {
        StateInstruction targetInstruction = new StateInstruction();
        targetInstruction.setStateMachineName(instruction.getStateMachineName());
        targetInstruction.setTenantId(instruction.getTenantId());
        targetInstruction.setStateName(instruction.getStateName());
        targetInstruction.setTemporaryState(instruction.getTemporaryState());
        return targetInstruction;
    }
}

