/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.engine.pcext.interceptors;

import io.seata.common.loader.LoadLevel;
import io.seata.common.util.StringUtils;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.saga.engine.exception.EngineExecutionException;
import io.seata.saga.engine.pcext.InterceptableStateHandler;
import io.seata.saga.engine.pcext.StateHandlerInterceptor;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.statelang.domain.StateMachineInstance;
import io.seata.tm.api.GlobalTransaction;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="InSagaBranch", order=50)
public class InSagaBranchHandlerInterceptor
implements StateHandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(InSagaBranchHandlerInterceptor.class);

    @Override
    public boolean match(Class<? extends InterceptableStateHandler> clazz) {
        return clazz != null;
    }

    @Override
    public void preProcess(ProcessContext context) throws EngineExecutionException {
        String previousXid;
        String xid = this.getXidFromProcessContext(context);
        if (StringUtils.isBlank(xid)) {
            LOGGER.warn("There is no xid in the process context.");
            return;
        }
        if (LOGGER.isWarnEnabled() && (previousXid = RootContext.getXID()) != null && !StringUtils.equalsIgnoreCase(previousXid, xid)) {
            LOGGER.warn("xid in change from {} to {}, Please don't use state machine engine in other global transaction.", (Object)previousXid, (Object)xid);
        }
        RootContext.bind(xid);
        RootContext.bindBranchType(BranchType.SAGA);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] Begin process the state instance in the saga branch.", (Object)xid);
        }
    }

    @Override
    public void postProcess(ProcessContext context, Exception exp) throws EngineExecutionException {
        String xid = RootContext.unbind();
        RootContext.unbindBranchType();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[{}] Finish process the state instance in the saga branch.", (Object)xid);
        }
    }

    protected String getXidFromProcessContext(ProcessContext context) {
        String xid = null;
        Map contextVariable = (Map)context.getVariable("context");
        if (contextVariable != null && contextVariable.containsKey("_global_transaction_")) {
            GlobalTransaction globalTransaction = (GlobalTransaction)contextVariable.get("_global_transaction_");
            xid = globalTransaction.getXid();
        } else {
            StateMachineInstance stateMachineInstance = (StateMachineInstance)context.getVariable("_current_statemachine_instance_");
            if (stateMachineInstance != null) {
                xid = stateMachineInstance.getId();
            }
        }
        return xid;
    }
}

