/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.http;

import io.seata.integration.http.AbstractHttpExecutor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class DefaultHttpExecutor
extends AbstractHttpExecutor {
    private static DefaultHttpExecutor instance = new DefaultHttpExecutor();

    private DefaultHttpExecutor() {
    }

    public static DefaultHttpExecutor getInstance() {
        return instance;
    }

    @Override
    public <T> void buildClientEntity(CloseableHttpClient httpClient, T paramObject) {
    }

    @Override
    public <T> void buildGetHeaders(Map<String, String> headers, T paramObject) {
    }

    @Override
    public String initGetUrl(String host, String path, Map<String, String> querys) {
        if (querys.isEmpty()) {
            return host + path;
        }
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((String)path)) {
            sbUrl.append(path);
        }
        StringBuilder sbQuery = new StringBuilder();
        for (Map.Entry<String, String> query : querys.entrySet()) {
            if (0 < sbQuery.length()) {
                sbQuery.append("&");
            }
            if (StringUtils.isBlank((String)query.getKey()) && !StringUtils.isBlank((String)query.getValue())) {
                sbQuery.append(query.getValue());
            }
            if (StringUtils.isBlank((String)query.getKey())) continue;
            sbQuery.append(query.getKey());
            if (StringUtils.isBlank((String)query.getValue())) continue;
            sbQuery.append("=");
            try {
                sbQuery.append(URLEncoder.encode(query.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (sbQuery.length() > 0) {
            sbUrl.append("?").append((CharSequence)sbQuery);
        }
        return sbUrl.toString();
    }

    @Override
    public <T> void buildPostHeaders(Map<String, String> headers, T t) {
    }

    @Override
    public <T> StringEntity buildEntity(StringEntity entity, T t) {
        return entity;
    }

    @Override
    public <K> K convertResult(HttpResponse response, Class<K> clazz) {
        if (clazz == HttpResponse.class) {
            return (K)response;
        }
        return null;
    }
}

