/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import io.seata.common.exception.NotSupportYetException;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.config.processor.ConfigProcessor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosConfiguration
extends AbstractConfiguration {
    private static volatile NacosConfiguration instance;
    private static final Logger LOGGER;
    private static final String DEFAULT_GROUP = "SEATA_GROUP";
    private static final String DEFAULT_DATA_ID = "seata.properties";
    private static final String GROUP_KEY = "group";
    private static final String PRO_SERVER_ADDR_KEY = "serverAddr";
    private static final String NACOS_DATA_ID_KEY = "dataId";
    private static final String CONFIG_TYPE = "nacos";
    private static final String DEFAULT_NAMESPACE = "";
    private static final String PRO_NAMESPACE_KEY = "namespace";
    private static final String USER_NAME = "username";
    private static final String PASSWORD = "password";
    private static final String ACCESS_KEY = "accessKey";
    private static final String SECRET_KEY = "secretKey";
    private static final String USE_PARSE_RULE = "false";
    private static final String CONTEXT_PATH = "contextPath";
    private static final Configuration FILE_CONFIG;
    private static volatile ConfigService configService;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final ConcurrentMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>> CONFIG_LISTENERS_MAP;
    private static volatile Properties seataConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NacosConfiguration getInstance() {
        if (instance != null) return instance;
        Class<NacosConfiguration> clazz = NacosConfiguration.class;
        synchronized (NacosConfiguration.class) {
            if (instance != null) return instance;
            instance = new NacosConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NacosConfiguration() {
        if (configService == null) {
            try {
                configService = NacosFactory.createConfigService((Properties)NacosConfiguration.getConfigProperties());
                NacosConfiguration.initSeataConfig();
            }
            catch (NacosException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = seataConfig.getProperty(dataId);
        if (null == value) {
            try {
                value = configService.getConfig(dataId, NacosConfiguration.getNacosGroup(), timeoutMills);
            }
            catch (NacosException exx) {
                LOGGER.error(exx.getErrMsg());
            }
        }
        return value == null ? defaultValue : value;
    }

    @Override
    public boolean putConfig(String dataId, String content, long timeoutMills) {
        boolean result = false;
        try {
            if (!seataConfig.isEmpty()) {
                seataConfig.setProperty(dataId, content);
                result = configService.publishConfig(NacosConfiguration.getNacosDataId(), NacosConfiguration.getNacosGroup(), NacosConfiguration.getSeataConfigStr());
            } else {
                result = configService.publishConfig(dataId, NacosConfiguration.getNacosGroup(), content);
            }
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        throw new NotSupportYetException("not support atomic operation putConfigIfAbsent");
    }

    @Override
    public boolean removeConfig(String dataId, long timeoutMills) {
        boolean result = false;
        try {
            if (!seataConfig.isEmpty()) {
                seataConfig.remove(dataId);
                result = configService.publishConfig(NacosConfiguration.getNacosDataId(), NacosConfiguration.getNacosGroup(), NacosConfiguration.getSeataConfigStr());
            } else {
                result = configService.removeConfig(dataId, NacosConfiguration.getNacosGroup());
            }
        }
        catch (NacosException exx) {
            LOGGER.error(exx.getErrMsg());
        }
        return result;
    }

    @Override
    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank(dataId) || listener == null) {
            return;
        }
        try {
            NacosListener nacosListener = new NacosListener(dataId, listener);
            CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> new ConcurrentHashMap()).put(listener, nacosListener);
            configService.addListener(dataId, NacosConfiguration.getNacosGroup(), (Listener)nacosListener);
        }
        catch (Exception exx) {
            LOGGER.error("add nacos listener error:{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    @Override
    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank(dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configChangeListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configChangeListeners)) {
            for (ConfigurationChangeListener entry : configChangeListeners) {
                if (!listener.equals(entry)) continue;
                NacosListener nacosListener = null;
                Map configListeners = (Map)CONFIG_LISTENERS_MAP.get(dataId);
                if (configListeners != null) {
                    nacosListener = (NacosListener)((Object)configListeners.get(listener));
                    configListeners.remove(entry);
                }
                if (nacosListener == null) break;
                configService.removeListener(dataId, NacosConfiguration.getNacosGroup(), (Listener)nacosListener);
                break;
            }
        }
    }

    @Override
    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        Map configListeners = (Map)CONFIG_LISTENERS_MAP.get(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            return configListeners.keySet();
        }
        return null;
    }

    private static Properties getConfigProperties() {
        String contextPath;
        String userName;
        Properties properties = new Properties();
        properties.setProperty("isUseCloudNamespaceParsing", USE_PARSE_RULE);
        properties.setProperty("isUseEndpointParsingRule", USE_PARSE_RULE);
        if (System.getProperty(PRO_SERVER_ADDR_KEY) != null) {
            properties.setProperty(PRO_SERVER_ADDR_KEY, System.getProperty(PRO_SERVER_ADDR_KEY));
        } else {
            String address = FILE_CONFIG.getConfig(NacosConfiguration.getNacosAddrFileKey());
            if (address != null) {
                properties.setProperty(PRO_SERVER_ADDR_KEY, address);
            }
        }
        if (System.getProperty(PRO_NAMESPACE_KEY) != null) {
            properties.setProperty(PRO_NAMESPACE_KEY, System.getProperty(PRO_NAMESPACE_KEY));
        } else {
            String namespace = FILE_CONFIG.getConfig(NacosConfiguration.getNacosNameSpaceFileKey());
            if (namespace == null) {
                namespace = DEFAULT_NAMESPACE;
            }
            properties.setProperty(PRO_NAMESPACE_KEY, namespace);
        }
        String string = userName = StringUtils.isNotBlank(System.getProperty(USER_NAME)) ? System.getProperty(USER_NAME) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosUserName());
        if (StringUtils.isNotBlank(userName)) {
            String password;
            String string2 = password = StringUtils.isNotBlank(System.getProperty(PASSWORD)) ? System.getProperty(PASSWORD) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosPassword());
            if (StringUtils.isNotBlank(password)) {
                properties.setProperty(USER_NAME, userName);
                properties.setProperty(PASSWORD, password);
                LOGGER.info("Nacos check auth with userName/password.");
            }
        } else {
            String accessKey;
            String string3 = accessKey = StringUtils.isNotBlank(System.getProperty(ACCESS_KEY)) ? System.getProperty(ACCESS_KEY) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosAccessKey());
            if (StringUtils.isNotBlank(accessKey)) {
                String secretKey;
                String string4 = secretKey = StringUtils.isNotBlank(System.getProperty(SECRET_KEY)) ? System.getProperty(SECRET_KEY) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosSecretKey());
                if (StringUtils.isNotBlank(secretKey)) {
                    properties.put(ACCESS_KEY, accessKey);
                    properties.put(SECRET_KEY, secretKey);
                    LOGGER.info("Nacos check auth with ak/sk.");
                }
            }
        }
        String string5 = contextPath = StringUtils.isNotBlank(System.getProperty(CONTEXT_PATH)) ? System.getProperty(CONTEXT_PATH) : FILE_CONFIG.getConfig(NacosConfiguration.getNacosContextPathKey());
        if (StringUtils.isNotBlank(contextPath)) {
            properties.setProperty(CONTEXT_PATH, contextPath);
        }
        return properties;
    }

    public static String getNacosNameSpaceFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_NAMESPACE_KEY);
    }

    public static String getNacosAddrFileKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PRO_SERVER_ADDR_KEY);
    }

    public static String getNacosGroupKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, GROUP_KEY);
    }

    public static String getNacosDataIdKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, NACOS_DATA_ID_KEY);
    }

    public static String getNacosUserName() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, USER_NAME);
    }

    public static String getNacosPassword() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, PASSWORD);
    }

    public static String getNacosAccessKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, ACCESS_KEY);
    }

    public static String getNacosSecretKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, SECRET_KEY);
    }

    private static String getNacosGroup() {
        return FILE_CONFIG.getConfig(NacosConfiguration.getNacosGroupKey(), DEFAULT_GROUP);
    }

    private static String getNacosDataId() {
        return FILE_CONFIG.getConfig(NacosConfiguration.getNacosDataIdKey(), DEFAULT_DATA_ID);
    }

    private static String getNacosDataType() {
        return ConfigProcessor.resolverConfigDataType(NacosConfiguration.getNacosDataId());
    }

    private static String getSeataConfigStr() {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enumeration = seataConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = seataConfig.getProperty(key);
            sb.append(key).append("=").append(property).append("\n");
        }
        return sb.toString();
    }

    private static String getNacosContextPathKey() {
        return String.join((CharSequence)".", "config", CONFIG_TYPE, CONTEXT_PATH);
    }

    private static void initSeataConfig() {
        try {
            String nacosDataId = NacosConfiguration.getNacosDataId();
            String config = configService.getConfig(nacosDataId, NacosConfiguration.getNacosGroup(), 5000L);
            if (StringUtils.isNotBlank(config)) {
                seataConfig = ConfigProcessor.processConfig(config, NacosConfiguration.getNacosDataType());
                NacosListener nacosListener = new NacosListener(nacosDataId, null);
                configService.addListener(nacosDataId, NacosConfiguration.getNacosGroup(), (Listener)nacosListener);
            }
        }
        catch (NacosException | IOException e) {
            LOGGER.error("init config properties error", e);
        }
    }

    @Override
    public String getTypeName() {
        return CONFIG_TYPE;
    }

    static {
        LOGGER = LoggerFactory.getLogger(NacosConfiguration.class);
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        CONFIG_LISTENERS_MAP = new ConcurrentHashMap<String, ConcurrentMap<ConfigurationChangeListener, NacosListener>>(8);
        seataConfig = new Properties();
    }

    public static class NacosListener
    extends AbstractSharedListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;

        public NacosListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            if (NacosConfiguration.getNacosDataId().equals(dataId)) {
                Properties seataConfigNew = new Properties();
                if (StringUtils.isNotBlank(configInfo)) {
                    try {
                        seataConfigNew = ConfigProcessor.processConfig(configInfo, NacosConfiguration.getNacosDataType());
                    }
                    catch (IOException e) {
                        LOGGER.error("load config properties error", (Throwable)e);
                        return;
                    }
                }
                for (Map.Entry entry : CONFIG_LISTENERS_MAP.entrySet()) {
                    String propertyNew;
                    String listenedDataId = (String)entry.getKey();
                    String propertyOld = seataConfig.getProperty(listenedDataId, NacosConfiguration.DEFAULT_NAMESPACE);
                    if (propertyOld.equals(propertyNew = seataConfigNew.getProperty(listenedDataId, NacosConfiguration.DEFAULT_NAMESPACE))) continue;
                    ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(listenedDataId).setNewValue(propertyNew).setNamespace(group);
                    ConcurrentMap configListeners = (ConcurrentMap)entry.getValue();
                    for (ConfigurationChangeListener configListener : configListeners.keySet()) {
                        configListener.onProcessEvent(event);
                    }
                }
                seataConfig = seataConfigNew;
                return;
            }
            ConfigurationChangeEvent event = new ConfigurationChangeEvent().setDataId(dataId).setNewValue(configInfo).setNamespace(group);
            this.listener.onProcessEvent(event);
        }
    }
}

