/*
 * Decompiled with CFR 0.152.
 */
package io.seata.sqlparser.antlr;

import io.seata.common.loader.LoadLevel;
import io.seata.sqlparser.SQLParsingException;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLRecognizerFactory;
import java.lang.reflect.Constructor;
import java.util.List;

@LoadLevel(name="antlr")
public class AntlrDelegatingSQLRecognizerFactory
implements SQLRecognizerFactory {
    private volatile SQLRecognizerFactory recognizerFactoryImpl;

    public AntlrDelegatingSQLRecognizerFactory() {
        this.setClassLoader();
    }

    void setClassLoader() {
        try {
            Class<?> recognizerFactoryImplClass = ClassLoader.getSystemClassLoader().loadClass("io.seata.sqlparser.antlr.mysql.AntlrMySQLRecognizerFactory");
            Constructor<?> implConstructor = recognizerFactoryImplClass.getDeclaredConstructor(new Class[0]);
            implConstructor.setAccessible(true);
            try {
                this.recognizerFactoryImpl = (SQLRecognizerFactory)implConstructor.newInstance(new Object[0]);
            }
            finally {
                implConstructor.setAccessible(false);
            }
        }
        catch (Exception e) {
            throw new SQLParsingException((Throwable)e);
        }
    }

    public List<SQLRecognizer> create(String sql, String dbType) {
        return this.recognizerFactoryImpl.create(sql, dbType);
    }
}

