/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import io.seata.common.util.CollectionUtils;
import io.seata.core.context.RootContext;
import io.seata.integration.http.HttpExecutor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpExecutor
implements HttpExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpExecutor.class);

    @Override
    public <T, K> K executePost(String host, String path, T paramObject, Class<K> returnType) throws IOException {
        Args.notNull(returnType, (String)"returnType");
        Args.notNull((Object)host, (String)"host");
        Args.notNull((Object)path, (String)"path");
        CloseableHttpClient httpClient = this.initHttpClientInstance(paramObject);
        HttpPost httpPost = new HttpPost(host + path);
        StringEntity entity = null;
        if (paramObject != null) {
            String content;
            if (paramObject instanceof String) {
                String sParam = (String)paramObject;
                JSONObject jsonObject = null;
                try {
                    jsonObject = JSON.parseObject((String)sParam);
                    content = jsonObject.toJSONString();
                }
                catch (JSONException e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(e.getMessage());
                    }
                    content = sParam;
                }
            } else {
                content = JSON.toJSONString(paramObject);
            }
            entity = new StringEntity(content, ContentType.APPLICATION_JSON);
        }
        if ((entity = this.buildEntity(entity, paramObject)) != null) {
            httpPost.setEntity((HttpEntity)entity);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        this.buildPostHeaders(headers, paramObject);
        return this.wrapHttpExecute(returnType, httpClient, (HttpUriRequest)httpPost, headers);
    }

    @Override
    public <K> K executeGet(String host, String path, Map<String, String> paramObject, Class<K> returnType) throws IOException {
        Args.notNull(returnType, (String)"returnType");
        Args.notNull((Object)host, (String)"host");
        Args.notNull((Object)path, (String)"path");
        CloseableHttpClient httpClient = this.initHttpClientInstance(paramObject);
        HttpGet httpGet = new HttpGet(this.initGetUrl(host, path, paramObject));
        HashMap<String, String> headers = new HashMap<String, String>();
        this.buildGetHeaders(headers, paramObject);
        return this.wrapHttpExecute(returnType, httpClient, (HttpUriRequest)httpGet, headers);
    }

    private <T> CloseableHttpClient initHttpClientInstance(T paramObject) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        this.buildClientEntity(httpClient, paramObject);
        return httpClient;
    }

    protected abstract <T> void buildClientEntity(CloseableHttpClient var1, T var2);

    private <K> K wrapHttpExecute(Class<K> returnType, CloseableHttpClient httpClient, HttpUriRequest httpUriRequest, Map<String, String> headers) throws IOException {
        CloseableHttpResponse response;
        int statusCode;
        String xid = RootContext.getXID();
        if (xid != null) {
            headers.put("TX_XID", xid);
        }
        if (!headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpUriRequest)httpUriRequest).addHeader(arg_0, arg_1));
        }
        if ((statusCode = (response = httpClient.execute(httpUriRequest)).getStatusLine().getStatusCode()) < 200 || statusCode > 207) {
            throw new RuntimeException("Failed to invoke the http method " + httpUriRequest.getURI() + " in the service . return status by: " + response.getStatusLine().getStatusCode());
        }
        return this.convertResult((HttpResponse)response, returnType);
    }

    protected abstract <T> void buildGetHeaders(Map<String, String> var1, T var2);

    protected abstract String initGetUrl(String var1, String var2, Map<String, String> var3);

    protected abstract <T> void buildPostHeaders(Map<String, String> var1, T var2);

    protected abstract <T> StringEntity buildEntity(StringEntity var1, T var2);

    protected abstract <K> K convertResult(HttpResponse var1, Class<K> var2);

    public static Map<String, String> convertParamOfBean(Object sourceParam) {
        return CollectionUtils.toStringMap((Map)((Map)JSON.parseObject((String)JSON.toJSONString((Object)sourceParam, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteMapNullValue}), Map.class)));
    }

    public static <T> Map<String, String> convertParamOfJsonString(String jsonStr, Class<T> returnType) {
        return AbstractHttpExecutor.convertParamOfBean(JSON.parseObject((String)jsonStr, returnType));
    }
}

