/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc.interceptor;

import com.alibaba.fastjson.JSON;
import io.seata.common.exception.FrameworkException;
import io.seata.common.exception.SkipCallbackWrapperException;
import io.seata.common.executor.Callback;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.NetUtil;
import io.seata.core.model.BranchType;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.tcc.TCCFenceHandler;
import io.seata.rm.tcc.api.BusinessActionContext;
import io.seata.rm.tcc.api.BusinessActionContextParameter;
import io.seata.rm.tcc.api.BusinessActionContextUtil;
import io.seata.rm.tcc.api.ParamType;
import io.seata.rm.tcc.api.TwoPhaseBusinessAction;
import io.seata.rm.tcc.interceptor.ActionContextUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ActionInterceptorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionInterceptorHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object proceed(Method method, Object[] arguments, String xid, TwoPhaseBusinessAction businessAction, Callback<Object> targetCallback) throws Throwable {
        BusinessActionContext actionContext = this.getOrCreateActionContextAndResetToArguments(method.getParameterTypes(), arguments);
        actionContext.setXid(xid);
        String actionName = businessAction.name();
        actionContext.setActionName(actionName);
        actionContext.setDelayReport(businessAction.isDelayReport());
        String branchId = this.doTccActionLogStore(method, arguments, businessAction, actionContext);
        actionContext.setBranchId(branchId);
        MDC.put((String)"X-TX-BRANCH-ID", (String)branchId);
        BusinessActionContext previousActionContext = BusinessActionContextUtil.getContext();
        try {
            BusinessActionContextUtil.setContext(actionContext);
            if (businessAction.useTCCFence()) {
                try {
                    Object object = TCCFenceHandler.prepareFence(xid, Long.valueOf(branchId), actionName, targetCallback);
                    return object;
                }
                catch (SkipCallbackWrapperException | UndeclaredThrowableException e) {
                    Throwable originException = e.getCause();
                    if (originException instanceof FrameworkException) {
                        LOGGER.error("[{}] prepare TCC fence error: {}", (Object)xid, (Object)originException.getMessage());
                    }
                    throw originException;
                }
            }
            Object object = targetCallback.execute();
            return object;
        }
        finally {
            try {
                BusinessActionContextUtil.reportContext(actionContext);
            }
            finally {
                if (previousActionContext != null) {
                    BusinessActionContextUtil.setContext(previousActionContext);
                } else {
                    BusinessActionContextUtil.clear();
                }
            }
        }
    }

    @Nonnull
    protected BusinessActionContext getOrCreateActionContextAndResetToArguments(Class<?>[] parameterTypes, Object[] arguments) {
        BusinessActionContext actionContext = null;
        int argIndex = 0;
        for (Class<?> parameterType : parameterTypes) {
            if (BusinessActionContext.class.isAssignableFrom(parameterType)) {
                actionContext = (BusinessActionContext)arguments[argIndex];
                if (actionContext == null) {
                    actionContext = new BusinessActionContext();
                    arguments[argIndex] = actionContext;
                    break;
                }
                actionContext.setUpdated(null);
                break;
            }
            ++argIndex;
        }
        if (actionContext == null) {
            actionContext = new BusinessActionContext();
        }
        return actionContext;
    }

    protected String doTccActionLogStore(Method method, Object[] arguments, TwoPhaseBusinessAction businessAction, BusinessActionContext actionContext) {
        String actionName = actionContext.getActionName();
        String xid = actionContext.getXid();
        Map<String, Object> context = this.fetchActionRequestContext(method, arguments);
        context.put("action-start-time", System.currentTimeMillis());
        this.initBusinessContext(context, method, businessAction);
        this.initFrameworkContext(context);
        Map<String, Object> originContext = actionContext.getActionContext();
        if (CollectionUtils.isNotEmpty(originContext)) {
            originContext.putAll(context);
            context = originContext;
        } else {
            actionContext.setActionContext(context);
        }
        Map<String, Map<String, Object>> applicationContext = Collections.singletonMap("actionContext", context);
        String applicationContextStr = JSON.toJSONString(applicationContext);
        try {
            Long branchId = DefaultResourceManager.get().branchRegister(BranchType.TCC, actionName, null, xid, applicationContextStr, null);
            return String.valueOf(branchId);
        }
        catch (Throwable t) {
            String msg = String.format("TCC branch Register error, xid: %s", xid);
            LOGGER.error(msg, t);
            throw new FrameworkException(t, msg);
        }
    }

    protected void initFrameworkContext(Map<String, Object> context) {
        try {
            context.put("host-name", NetUtil.getLocalIp((String[])new String[0]));
        }
        catch (Throwable t) {
            LOGGER.warn("getLocalIP error", t);
        }
    }

    protected void initBusinessContext(Map<String, Object> context, Method method, TwoPhaseBusinessAction businessAction) {
        if (method != null) {
            context.put("sys::prepare", method.getName());
        }
        if (businessAction != null) {
            context.put("sys::commit", businessAction.commitMethod());
            context.put("sys::rollback", businessAction.rollbackMethod());
            context.put("actionName", businessAction.name());
            context.put("useTCCFence", businessAction.useTCCFence());
        }
    }

    protected Map<String, Object> fetchActionRequestContext(Method method, Object[] arguments) {
        HashMap<String, Object> context = new HashMap<String, Object>(8);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                if (!(parameterAnnotations[i][j] instanceof BusinessActionContextParameter)) continue;
                BusinessActionContextParameter annotation = (BusinessActionContextParameter)parameterAnnotations[i][j];
                if (arguments[i] == null) {
                    throw new IllegalArgumentException("@BusinessActionContextParameter 's params can not null");
                }
                Object paramObject = arguments[i];
                if (paramObject == null) continue;
                ActionContextUtil.loadParamByAnnotationAndPutToContext(ParamType.PARAM, "", paramObject, annotation, context);
            }
        }
        return context;
    }
}

