/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import io.seata.core.rpc.Disposable;
import io.seata.server.Server;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class ServerRunner
implements CommandLineRunner,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerRunner.class);
    private boolean started = Boolean.FALSE;
    private static final List<Disposable> DISPOSABLE_LIST = new CopyOnWriteArrayList<Disposable>();

    public static void addDisposable(Disposable disposable) {
        DISPOSABLE_LIST.add(disposable);
    }

    public void run(String ... args) {
        try {
            long start = System.currentTimeMillis();
            Server.start(args);
            this.started = true;
            long cost = System.currentTimeMillis() - start;
            LOGGER.info("seata server started in {} millSeconds", (Object)cost);
        }
        catch (Throwable e) {
            this.started = Boolean.FALSE;
            LOGGER.error("seata server start error: {} ", (Object)e.getMessage(), (Object)e);
            System.exit(-1);
        }
    }

    public boolean started() {
        return this.started;
    }

    public void destroy() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll starting");
        }
        for (Disposable disposable : DISPOSABLE_LIST) {
            disposable.destroy();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll finish");
        }
    }
}

