/*
 * Decompiled with CFR 0.152.
 */
package io.seata.integration.brpc;

import com.baidu.brpc.interceptor.AbstractInterceptor;
import com.baidu.brpc.interceptor.InterceptorChain;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.protocol.Response;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionPropagationServerInterceptor
extends AbstractInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionPropagationServerInterceptor.class);

    public boolean handleRequest(Request request) {
        String branchType = this.getRpcBranchType(request);
        String xid = RootContext.getXID();
        String rpcXid = this.getRpcXid(request);
        if (null == xid && null != rpcXid) {
            RootContext.bind((String)rpcXid);
            RootContext.bindBranchType((BranchType)BranchType.valueOf((String)branchType));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SEATA-BRPC[{}], bind [{}] to RootContext", (Object)branchType, (Object)rpcXid);
            }
        }
        return super.handleRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aroundProcess(Request brpcRequest, Response brpcResponse, InterceptorChain chain) throws Exception {
        try {
            chain.intercept(brpcRequest, brpcResponse);
        }
        catch (Throwable throwable) {
            String unbindXid = RootContext.unbind();
            String rpcXid = this.getRpcXid(brpcRequest);
            BranchType branchType = RootContext.unbindBranchType();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("SEATA-BRPC[{}]: unbind[{}] from RootContext", (Object)branchType, (Object)unbindXid);
            }
            if (null != rpcXid && !rpcXid.equalsIgnoreCase(unbindXid)) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("SEATA-BRPC[{}]: xid in change during RPC from [{}] to [{}]", new Object[]{branchType, rpcXid, unbindXid});
                }
                if (unbindXid != null) {
                    RootContext.bind((String)unbindXid);
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("SEATA-BRPC[{}]: bind [{}] back to RootContext", (Object)branchType, (Object)unbindXid);
                    }
                }
            }
            throw throwable;
        }
        String unbindXid = RootContext.unbind();
        String rpcXid = this.getRpcXid(brpcRequest);
        BranchType branchType = RootContext.unbindBranchType();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("SEATA-BRPC[{}]: unbind[{}] from RootContext", (Object)branchType, (Object)unbindXid);
        }
        if (null != rpcXid && !rpcXid.equalsIgnoreCase(unbindXid)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("SEATA-BRPC[{}]: xid in change during RPC from [{}] to [{}]", new Object[]{branchType, rpcXid, unbindXid});
            }
            if (unbindXid != null) {
                RootContext.bind((String)unbindXid);
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("SEATA-BRPC[{}]: bind [{}] back to RootContext", (Object)branchType, (Object)unbindXid);
                }
            }
        }
    }

    private String getRpcXid(Request brpcRequest) {
        Map kvAttachment = brpcRequest.getKvAttachment();
        if (null == kvAttachment) {
            return null;
        }
        return (String)kvAttachment.get("TX_XID");
    }

    private String getRpcBranchType(Request brpcRequest) {
        Map kvAttachment = brpcRequest.getKvAttachment();
        if (null == kvAttachment) {
            return null;
        }
        return (String)kvAttachment.get("TX_BRANCH_TYPE");
    }
}

