/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.xa;

import io.seata.common.thread.NamedThreadFactory;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.BranchStatus;
import io.seata.core.model.BranchType;
import io.seata.core.model.Resource;
import io.seata.rm.BaseDataSourceResource;
import io.seata.rm.datasource.AbstractDataSourceCacheResourceManager;
import io.seata.rm.datasource.xa.AbstractDataSourceProxyXA;
import io.seata.rm.datasource.xa.ConnectionProxyXA;
import io.seata.rm.datasource.xa.DataSourceProxyXA;
import io.seata.rm.datasource.xa.XAXid;
import io.seata.rm.datasource.xa.XAXidBuilder;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManagerXA
extends AbstractDataSourceCacheResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManagerXA.class);
    private static final int TWO_PHASE_HOLD_TIMEOUT = ConfigurationFactory.getInstance().getInt("client.rm.connectionTwoPhaseHoldTimeoutXA", 10000);
    private static final long SCHEDULE_DELAY_MILLS = 60000L;
    private static final long SCHEDULE_INTERVAL_MILLS = 1000L;
    protected volatile ScheduledExecutorService xaTwoPhaseTimeoutChecker;

    @Override
    public void init() {
        LOGGER.info("ResourceManagerXA init ...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initXaTwoPhaseTimeoutChecker() {
        if (this.xaTwoPhaseTimeoutChecker == null) {
            ResourceManagerXA resourceManagerXA = this;
            synchronized (resourceManagerXA) {
                boolean shouldBeHold;
                if (this.xaTwoPhaseTimeoutChecker == null && (shouldBeHold = this.dataSourceCache.values().parallelStream().anyMatch(resource -> {
                    if (resource instanceof DataSourceProxyXA) {
                        return ((DataSourceProxyXA)resource).isShouldBeHeld();
                    }
                    return false;
                }))) {
                    this.xaTwoPhaseTimeoutChecker = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("xaTwoPhaseTimeoutChecker", 1, true));
                    this.xaTwoPhaseTimeoutChecker.scheduleAtFixedRate(() -> {
                        for (Map.Entry entry : this.dataSourceCache.entrySet()) {
                            BaseDataSourceResource resource = (BaseDataSourceResource)entry.getValue();
                            if (!resource.isShouldBeHeld() || !(resource instanceof DataSourceProxyXA)) continue;
                            Map keeper = resource.getKeeper();
                            for (Map.Entry connectionEntry : keeper.entrySet()) {
                                ConnectionProxyXA connection = (ConnectionProxyXA)connectionEntry.getValue();
                                long now = System.currentTimeMillis();
                                ConnectionProxyXA connectionProxyXA = connection;
                                synchronized (connectionProxyXA) {
                                    if (connection.getPrepareTime() != null && now - connection.getPrepareTime() > (long)TWO_PHASE_HOLD_TIMEOUT) {
                                        try {
                                            connection.closeForce();
                                        }
                                        catch (SQLException e) {
                                            LOGGER.info("Force close the xa physical connection fail", (Throwable)e);
                                        }
                                    }
                                }
                            }
                        }
                    }, 60000L, 1000L, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.XA;
    }

    @Override
    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.finishBranch(true, branchType, xid, branchId, resourceId, applicationData);
    }

    @Override
    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        return this.finishBranch(false, branchType, xid, branchId, resourceId, applicationData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BranchStatus finishBranch(boolean committed, BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        XAXid xaBranchXid = XAXidBuilder.build(xid, branchId);
        Resource resource = (Resource)this.dataSourceCache.get(resourceId);
        if (!(resource instanceof AbstractDataSourceProxyXA)) {
            LOGGER.error("Unknown Resource for XA resource " + resourceId + " " + resource);
            if (!committed) return BranchStatus.PhaseTwo_RollbackFailed_Unretryable;
            return BranchStatus.PhaseTwo_CommitFailed_Unretryable;
        }
        try (ConnectionProxyXA connectionProxyXA = ((AbstractDataSourceProxyXA)resource).getConnectionForXAFinish(xaBranchXid);){
            if (committed) {
                connectionProxyXA.xaCommit(xid, branchId, applicationData);
                LOGGER.info(xaBranchXid + " was committed.");
                BranchStatus branchStatus2 = BranchStatus.PhaseTwo_Committed;
                return branchStatus2;
            }
            connectionProxyXA.xaRollback(xid, branchId, applicationData);
            LOGGER.info(xaBranchXid + " was rollbacked");
            BranchStatus branchStatus = BranchStatus.PhaseTwo_Rollbacked;
            return branchStatus;
        }
        catch (SQLException | XAException sqle) {
            if (sqle instanceof XAException) {
                block16: {
                    block17: {
                        BranchStatus branchStatus3;
                        try {
                            if (((XAException)sqle).errorCode != -4) break block16;
                            if (!committed) break block17;
                            branchStatus3 = BranchStatus.PhaseTwo_CommitFailed_XAER_NOTA_Retryable;
                            BaseDataSourceResource.setBranchStatus(xaBranchXid.toString(), committed ? BranchStatus.PhaseTwo_Committed : BranchStatus.PhaseTwo_Rollbacked);
                        }
                        catch (Throwable throwable3) {
                            BaseDataSourceResource.setBranchStatus(xaBranchXid.toString(), committed ? BranchStatus.PhaseTwo_Committed : BranchStatus.PhaseTwo_Rollbacked);
                            throw throwable3;
                        }
                        return branchStatus3;
                    }
                    BranchStatus branchStatus4 = BranchStatus.PhaseTwo_RollbackFailed_XAER_NOTA_Retryable;
                    BaseDataSourceResource.setBranchStatus(xaBranchXid.toString(), committed ? BranchStatus.PhaseTwo_Committed : BranchStatus.PhaseTwo_Rollbacked);
                    return branchStatus4;
                }
                BaseDataSourceResource.setBranchStatus(xaBranchXid.toString(), committed ? BranchStatus.PhaseTwo_Committed : BranchStatus.PhaseTwo_Rollbacked);
            }
            if (committed) {
                LOGGER.info(xaBranchXid + " commit failed since " + sqle.getMessage(), (Throwable)sqle);
                return BranchStatus.PhaseTwo_CommitFailed_Retryable;
            }
            LOGGER.info(xaBranchXid + " rollback failed since " + sqle.getMessage(), (Throwable)sqle);
            return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
        }
    }
}

