/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm;

import io.seata.core.model.BranchType;
import io.seata.core.model.ResourceManager;
import io.seata.core.protocol.transaction.UndoLogDeleteRequest;
import io.seata.rm.AbstractRMHandler;
import io.seata.rm.DefaultResourceManager;
import io.seata.rm.datasource.DataSourceManager;
import io.seata.rm.datasource.DataSourceProxy;
import io.seata.rm.datasource.undo.UndoLogManager;
import io.seata.rm.datasource.undo.UndoLogManagerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMHandlerAT
extends AbstractRMHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMHandlerAT.class);
    private static final int LIMIT_ROWS = 3000;
    private final Map<String, Boolean> undoLogTableExistRecord = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void handle(UndoLogDeleteRequest request) {
        String resourceId = request.getResourceId();
        DataSourceManager dataSourceManager = (DataSourceManager)this.getResourceManager();
        DataSourceProxy dataSourceProxy = dataSourceManager.get(resourceId);
        if (dataSourceProxy == null) {
            LOGGER.warn("Failed to get dataSourceProxy for delete undolog on {}", (Object)resourceId);
            return;
        }
        boolean hasUndoLogTable = this.undoLogTableExistRecord.computeIfAbsent(resourceId, id -> this.checkUndoLogTableExist(dataSourceProxy));
        if (!hasUndoLogTable) {
            LOGGER.debug("resource({}) has no undo_log table, UndoLogDeleteRequest will be ignored", (Object)resourceId);
            return;
        }
        Date division = this.getLogCreated(request.getSaveDays());
        UndoLogManager manager = this.getUndoLogManager(dataSourceProxy);
        try (Connection conn = this.getConnection(dataSourceProxy);){
            int deleteRows;
            if (conn == null) {
                LOGGER.warn("Failed to get connection to delete expired undo_log for {}", (Object)resourceId);
                return;
            }
            while ((deleteRows = this.deleteUndoLog(manager, conn, division)) == 3000) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkUndoLogTableExist(DataSourceProxy dataSourceProxy) {
        UndoLogManager manager = this.getUndoLogManager(dataSourceProxy);
        try (Connection connection = this.getConnection(dataSourceProxy);){
            if (connection == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = manager.hasUndoLogTable(connection);
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    Connection getConnection(DataSourceProxy dataSourceProxy) {
        try {
            return dataSourceProxy.getPlainConnection();
        }
        catch (SQLException e) {
            String resourceId = dataSourceProxy.getResourceId();
            LOGGER.error("Failed to get connection for {}", (Object)resourceId, (Object)e);
            return null;
        }
    }

    UndoLogManager getUndoLogManager(DataSourceProxy dataSourceProxy) {
        return UndoLogManagerFactory.getUndoLogManager(dataSourceProxy.getDbType());
    }

    int deleteUndoLog(UndoLogManager manager, Connection conn, Date division) {
        try {
            int deleteRows = manager.deleteUndoLogByLogCreated(division, 3000, conn);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            return deleteRows;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to delete expired undo_log", (Throwable)e);
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException re) {
                LOGGER.error("Failed to rollback undolog", (Throwable)re);
            }
            return 0;
        }
    }

    private Date getLogCreated(int saveDays) {
        if (saveDays <= 0) {
            saveDays = 7;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -saveDays);
        return calendar.getTime();
    }

    @Override
    protected ResourceManager getResourceManager() {
        return DefaultResourceManager.get().getResourceManager(BranchType.AT);
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

