/*
 * Decompiled with CFR 0.152.
 */
package io.seata.compressor.gzip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    private static final int BUFFER_SIZE = 8192;

    private GzipUtil() {
    }

    public static byte[] compress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        try {
            gzip.write(bytes);
            gzip.flush();
            gzip.finish();
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("gzip compress error", e);
            }
        }
        gzip.close();
        return byArray;
    }

    public static byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPInputStream gunzip = new GZIPInputStream(new ByteArrayInputStream(bytes));
        try {
            int n;
            byte[] buffer = new byte[8192];
            while ((n = gunzip.read(buffer)) > -1) {
                out.write(buffer, 0, n);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gunzip.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("gzip decompress error", e);
            }
        }
        gunzip.close();
        return byArray;
    }
}

