/*
 * Decompiled with CFR 0.152.
 */
package io.seata.compressor.bzip2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class BZip2Util {
    private static final int BUFFER_SIZE = 8192;

    public static byte[] compress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CBZip2OutputStream bzip2 = new CBZip2OutputStream((OutputStream)bos);
        try {
            bzip2.write(bytes);
            bzip2.finish();
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bzip2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("BZip2 compress error", e);
            }
        }
        bzip2.close();
        return byArray;
    }

    public static byte[] decompress(byte[] bytes) {
        byte[] byArray;
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        CBZip2InputStream bzip2 = new CBZip2InputStream((InputStream)bis);
        try {
            int n;
            byte[] buffer = new byte[8192];
            while ((n = bzip2.read(buffer)) > -1) {
                out.write(buffer, 0, n);
            }
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bzip2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("BZip2 decompress error", e);
            }
        }
        bzip2.close();
        return byArray;
    }
}

