/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.file.session;

import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.loader.LoadLevel;
import io.seata.common.loader.Scope;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.core.exception.TransactionException;
import io.seata.core.model.GlobalStatus;
import io.seata.server.session.AbstractSessionManager;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.Reloadable;
import io.seata.server.session.SessionCondition;
import io.seata.server.storage.file.ReloadableStore;
import io.seata.server.storage.file.TransactionWriteStore;
import io.seata.server.storage.file.store.FileTransactionStoreManager;
import io.seata.server.store.AbstractTransactionStoreManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.TransactionStoreManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@LoadLevel(name="file", scope=Scope.PROTOTYPE)
public class FileSessionManager
extends AbstractSessionManager
implements Reloadable {
    private static final int READ_SIZE = ConfigurationFactory.getInstance().getInt("store.file.sessionReloadReadSize", 100);
    private Map<String, GlobalSession> sessionMap = new ConcurrentHashMap<String, GlobalSession>();

    public FileSessionManager(String name, String sessionStoreFilePath) throws IOException {
        super(name);
        this.transactionStoreManager = StringUtils.isNotBlank((String)sessionStoreFilePath) ? new FileTransactionStoreManager(sessionStoreFilePath + File.separator + name, this) : new AbstractTransactionStoreManager(){

            @Override
            public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
                return true;
            }
        };
    }

    @Override
    public void reload() {
        this.restoreSessions();
    }

    @Override
    public void addGlobalSession(GlobalSession session) throws TransactionException {
        CollectionUtils.computeIfAbsent(this.sessionMap, (Object)session.getXid(), k -> {
            try {
                super.addGlobalSession(session);
            }
            catch (TransactionException e) {
                LOGGER.error("addGlobalSession fail, msg: {}", (Object)e.getMessage());
            }
            return session;
        });
    }

    @Override
    public GlobalSession findGlobalSession(String xid) {
        return this.sessionMap.get(xid);
    }

    @Override
    public GlobalSession findGlobalSession(String xid, boolean withBranchSessions) {
        return this.sessionMap.get(xid);
    }

    @Override
    public void removeGlobalSession(GlobalSession session) throws TransactionException {
        if (this.sessionMap.remove(session.getXid()) != null) {
            super.removeGlobalSession(session);
        }
    }

    @Override
    public Collection<GlobalSession> allSessions() {
        return this.sessionMap.values();
    }

    @Override
    public List<GlobalSession> findGlobalSessions(SessionCondition condition) {
        ArrayList<GlobalSession> found = new ArrayList<GlobalSession>();
        List<GlobalStatus> globalStatuses = null;
        if (null != condition.getStatuses() && condition.getStatuses().length > 0) {
            globalStatuses = Arrays.asList(condition.getStatuses());
        }
        for (GlobalSession globalSession : this.sessionMap.values()) {
            if (null != condition.getOverTimeAliveMills() && condition.getOverTimeAliveMills() > 0L && System.currentTimeMillis() - globalSession.getBeginTime() <= condition.getOverTimeAliveMills()) continue;
            if (!StringUtils.isEmpty((CharSequence)condition.getXid())) {
                if (!Objects.equals(condition.getXid(), globalSession.getXid())) continue;
                found.add(globalSession);
                return found;
            }
            if (null != condition.getTransactionId() && condition.getTransactionId() > 0L) {
                if (!Objects.equals(condition.getTransactionId(), globalSession.getTransactionId())) continue;
                found.add(globalSession);
                return found;
            }
            if (null != globalStatuses && !globalStatuses.contains(globalSession.getStatus())) continue;
            found.add(globalSession);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lockAndExecute(GlobalSession globalSession, GlobalSession.LockCallable<T> lockCallable) throws TransactionException {
        globalSession.lock();
        try {
            T t = lockCallable.call();
            return t;
        }
        finally {
            globalSession.unlock();
        }
    }

    private void restoreSessions() {
        HashSet<String> removedGlobalBuffer = new HashSet<String>();
        HashMap<String, Map<Long, BranchSession>> unhandledBranchBuffer = new HashMap<String, Map<Long, BranchSession>>();
        this.restoreSessions(true, removedGlobalBuffer, unhandledBranchBuffer);
        this.restoreSessions(false, removedGlobalBuffer, unhandledBranchBuffer);
        if (!unhandledBranchBuffer.isEmpty()) {
            unhandledBranchBuffer.values().forEach(unhandledBranchSessions -> unhandledBranchSessions.values().forEach(branchSession -> {
                String xid = branchSession.getXid();
                if (removedGlobalBuffer.contains(xid)) {
                    return;
                }
                long bid = branchSession.getBranchId();
                GlobalSession found = this.sessionMap.get(xid);
                if (found == null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("GlobalSession Does Not Exists For BranchSession [" + bid + "/" + xid + "]");
                    }
                } else {
                    BranchSession existingBranch = found.getBranch(branchSession.getBranchId());
                    if (existingBranch == null) {
                        found.add((BranchSession)branchSession);
                    } else {
                        existingBranch.setStatus(branchSession.getStatus());
                    }
                }
            }));
        }
    }

    private boolean checkSessionStatus(GlobalSession globalSession) {
        GlobalStatus globalStatus = globalSession.getStatus();
        switch (globalStatus) {
            case UnKnown: 
            case Committed: 
            case CommitFailed: 
            case Rollbacked: 
            case RollbackFailed: 
            case TimeoutRollbacked: 
            case TimeoutRollbackFailed: 
            case Finished: {
                return false;
            }
        }
        return true;
    }

    private void restoreSessions(boolean isHistory, Set<String> removedGlobalBuffer, Map<String, Map<Long, BranchSession>> unhandledBranchBuffer) {
        if (!(this.transactionStoreManager instanceof ReloadableStore)) {
            return;
        }
        while (((ReloadableStore)((Object)this.transactionStoreManager)).hasRemaining(isHistory)) {
            List<TransactionWriteStore> stores = ((ReloadableStore)((Object)this.transactionStoreManager)).readWriteStore(READ_SIZE, isHistory);
            this.restore(stores, removedGlobalBuffer, unhandledBranchBuffer);
        }
    }

    private void restore(List<TransactionWriteStore> stores, Set<String> removedGlobalBuffer, Map<String, Map<Long, BranchSession>> unhandledBranchBuffer) {
        block6: for (TransactionWriteStore store : stores) {
            TransactionStoreManager.LogOperation logOperation = store.getOperate();
            SessionStorable sessionStorable = store.getSessionRequest();
            switch (logOperation) {
                case GLOBAL_ADD: 
                case GLOBAL_UPDATE: {
                    GlobalSession globalSession = (GlobalSession)sessionStorable;
                    if (globalSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore globalSession from file failed, the transactionId is zero , xid:" + globalSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(globalSession.getXid())) break;
                    GlobalSession foundGlobalSession = this.sessionMap.get(globalSession.getXid());
                    if (foundGlobalSession == null) {
                        if (this.checkSessionStatus(globalSession)) {
                            this.sessionMap.put(globalSession.getXid(), globalSession);
                            break;
                        }
                        removedGlobalBuffer.add(globalSession.getXid());
                        unhandledBranchBuffer.remove(globalSession.getXid());
                        break;
                    }
                    if (this.checkSessionStatus(globalSession)) {
                        foundGlobalSession.setStatus(globalSession.getStatus());
                        break;
                    }
                    this.sessionMap.remove(globalSession.getXid());
                    removedGlobalBuffer.add(globalSession.getXid());
                    unhandledBranchBuffer.remove(globalSession.getXid());
                    break;
                }
                case GLOBAL_REMOVE: {
                    GlobalSession globalSession = (GlobalSession)sessionStorable;
                    if (globalSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore globalSession from file failed, the transactionId is zero , xid:" + globalSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(globalSession.getXid())) break;
                    if (this.sessionMap.remove(globalSession.getXid()) == null && LOGGER.isInfoEnabled()) {
                        LOGGER.info("GlobalSession To Be Removed Does Not Exists [" + globalSession.getXid() + "]");
                    }
                    removedGlobalBuffer.add(globalSession.getXid());
                    unhandledBranchBuffer.remove(globalSession.getXid());
                    break;
                }
                case BRANCH_ADD: 
                case BRANCH_UPDATE: {
                    BranchSession branchSession = (BranchSession)sessionStorable;
                    if (branchSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore branchSession from file failed, the transactionId is zero , xid:" + branchSession.getXid());
                        break;
                    }
                    if (removedGlobalBuffer.contains(branchSession.getXid())) break;
                    GlobalSession foundGlobalSession = this.sessionMap.get(branchSession.getXid());
                    if (foundGlobalSession == null) {
                        unhandledBranchBuffer.computeIfAbsent(branchSession.getXid(), key -> new HashMap()).put(branchSession.getBranchId(), branchSession);
                        break;
                    }
                    BranchSession existingBranch = foundGlobalSession.getBranch(branchSession.getBranchId());
                    if (existingBranch == null) {
                        foundGlobalSession.add(branchSession);
                        break;
                    }
                    existingBranch.setStatus(branchSession.getStatus());
                    break;
                }
                case BRANCH_REMOVE: {
                    BranchSession branchSession = (BranchSession)sessionStorable;
                    String xid = branchSession.getXid();
                    if (removedGlobalBuffer.contains(xid)) break;
                    long bid = branchSession.getBranchId();
                    if (branchSession.getTransactionId() == 0L) {
                        LOGGER.error("Restore branchSession from file failed, the transactionId is zero , xid:" + branchSession.getXid());
                        break;
                    }
                    GlobalSession found = this.sessionMap.get(xid);
                    if (found == null) {
                        if (!LOGGER.isInfoEnabled()) continue block6;
                        LOGGER.info("GlobalSession To Be Updated (Remove Branch) Does Not Exists [" + bid + "/" + xid + "]");
                        break;
                    }
                    BranchSession theBranch = found.getBranch(bid);
                    if (theBranch == null) {
                        if (!LOGGER.isInfoEnabled()) continue block6;
                        LOGGER.info("BranchSession To Be Updated Does Not Exists [" + bid + "/" + xid + "]");
                        break;
                    }
                    found.remove(theBranch);
                    break;
                }
                default: {
                    throw new ShouldNeverHappenException("Unknown Operation: " + (Object)((Object)logOperation));
                }
            }
        }
    }

    @Override
    public void destroy() {
        this.transactionStoreManager.shutdown();
    }
}

