/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server;

import io.seata.common.holder.ObjectHolder;
import io.seata.common.util.StringUtils;
import io.seata.server.store.StoreConfig;
import io.seata.spring.boot.autoconfigure.SeataCoreEnvironmentPostProcessor;
import io.seata.spring.boot.autoconfigure.SeataServerEnvironmentPostProcessor;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class ServerApplicationListener
implements GenericApplicationListener {
    public boolean supportsEventType(ResolvableType eventType) {
        return eventType.getRawClass() != null && ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(eventType.getRawClass());
    }

    public void onApplicationEvent(ApplicationEvent event) {
        String dPort;
        if (!(event instanceof ApplicationEnvironmentPreparedEvent)) {
            return;
        }
        ApplicationEnvironmentPreparedEvent environmentPreparedEvent = (ApplicationEnvironmentPreparedEvent)event;
        ConfigurableEnvironment environment = environmentPreparedEvent.getEnvironment();
        ObjectHolder.INSTANCE.setObject("springConfigurableEnvironment", (Object)environment);
        SeataCoreEnvironmentPostProcessor.init();
        SeataServerEnvironmentPostProcessor.init();
        System.setProperty("sessionMode", StoreConfig.getSessionMode().getName());
        System.setProperty("lockMode", StoreConfig.getLockMode().getName());
        String[] args = environmentPreparedEvent.getArgs();
        if (args != null && args.length >= 2) {
            for (int i = 0; i < args.length; ++i) {
                if (!"-p".equalsIgnoreCase(args[i]) || i >= args.length - 1) continue;
                this.setTargetPort(environment, args[i + 1], true);
                return;
            }
        }
        if (StringUtils.isNotBlank((String)(dPort = (String)environment.getProperty("server.servicePort", String.class)))) {
            this.setTargetPort(environment, dPort, true);
            return;
        }
        String envPort = (String)environment.getProperty("SEATA_PORT", String.class);
        if (StringUtils.isNotBlank((String)envPort)) {
            this.setTargetPort(environment, envPort, true);
            return;
        }
        String configPort = (String)environment.getProperty("seata.server.service-port", String.class);
        if (StringUtils.isNotBlank((String)configPort)) {
            this.setTargetPort(environment, configPort, false);
            return;
        }
        String serverPort = (String)environment.getProperty("server.port", String.class);
        if (StringUtils.isBlank((String)serverPort)) {
            serverPort = "8080";
        }
        String servicePort = String.valueOf(Integer.parseInt(serverPort) + 1000);
        this.setTargetPort(environment, servicePort, true);
    }

    private void setTargetPort(ConfigurableEnvironment environment, String port, boolean needAddPropertySource) {
        System.setProperty("server.servicePort", port);
        if (needAddPropertySource) {
            Properties pro = new Properties();
            pro.setProperty("seata.server.service-port", port);
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("serverProperties", pro));
        }
    }

    public int getOrder() {
        return -2147483629;
    }
}

