/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.env;

import io.seata.common.util.CollectionUtils;
import io.seata.common.util.MapUtil;
import io.seata.common.util.NumberUtils;
import io.seata.common.util.StringUtils;
import io.seata.server.env.ContainerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ResourceUtils;
import org.yaml.snakeyaml.Yaml;

public class PortHelper {
    public static int getPortFromEnvOrStartup(String[] args) {
        int port = 0;
        if (args != null && args.length >= 2) {
            for (int i = 0; i < args.length; ++i) {
                if (!"-p".equalsIgnoreCase(args[i]) || i >= args.length - 1) continue;
                port = NumberUtils.toInt((String)args[i + 1], (int)0);
            }
        }
        if (port == 0) {
            port = ContainerHelper.getPort();
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPortFromConfigFile() throws IOException {
        int port = 8080;
        File configFile = null;
        File startupConfigFile = PortHelper.getConfigFromStartup();
        if (null != startupConfigFile) {
            configFile = startupConfigFile;
        } else {
            try {
                File propertiesFile;
                configFile = propertiesFile = ResourceUtils.getFile((String)"classpath:application.properties");
            }
            catch (FileNotFoundException exx) {
                File ymlFile;
                configFile = ymlFile = ResourceUtils.getFile((String)"classpath:application.yml");
            }
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(configFile);
            String fileName = configFile.getName();
            String portNum = null;
            if (fileName.endsWith("yml")) {
                Object serverPort;
                Map yamlMap = (Map)new Yaml().load((InputStream)inputStream);
                Map configMap = MapUtil.getFlattenedMap((Map)yamlMap);
                if (CollectionUtils.isNotEmpty((Map)configMap) && null != (serverPort = configMap.get("server.port"))) {
                    portNum = serverPort.toString();
                }
            } else {
                Properties properties = new Properties();
                properties.load(inputStream);
                portNum = properties.getProperty("server.port");
            }
            if (null != portNum) {
                try {
                    port = Integer.parseInt(portNum);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (null != inputStream) {
                ((InputStream)inputStream).close();
            }
        }
        return port;
    }

    private static File getConfigFromStartup() {
        String configLocation = System.getProperty("spring.config.location");
        if (StringUtils.isNotBlank((String)configLocation)) {
            try {
                File configFile = ResourceUtils.getFile((String)configLocation);
                if (!configFile.isFile()) {
                    return null;
                }
                String fileName = configFile.getName();
                if (!fileName.endsWith("yml") && !fileName.endsWith("properties")) {
                    return null;
                }
                return configFile;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return null;
    }
}

