/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.session;

import io.seata.core.model.GlobalStatus;

public class SessionStatusValidator {
    public static boolean isTimeoutGlobalStatus(GlobalStatus status) {
        return status == GlobalStatus.TimeoutRollbacked || status == GlobalStatus.TimeoutRollbackFailed || status == GlobalStatus.TimeoutRollbacking || status == GlobalStatus.TimeoutRollbackRetrying;
    }

    public static boolean isRollbackGlobalStatus(GlobalStatus status) {
        return status == GlobalStatus.Rollbacking || status == GlobalStatus.RollbackRetrying || status == GlobalStatus.Rollbacked || status == GlobalStatus.RollbackFailed || status == GlobalStatus.RollbackRetryTimeout;
    }

    public static boolean isCommitGlobalStatus(GlobalStatus status) {
        return status == GlobalStatus.Committing || status == GlobalStatus.AsyncCommitting || status == GlobalStatus.CommitRetrying || status == GlobalStatus.Committed || status == GlobalStatus.CommitFailed || status == GlobalStatus.CommitRetryTimeout;
    }

    public static boolean validateUpdateStatus(GlobalStatus before, GlobalStatus after) {
        if (SessionStatusValidator.isTimeoutGlobalStatus(before) && SessionStatusValidator.isCommitGlobalStatus(after)) {
            return false;
        }
        if (SessionStatusValidator.isCommitGlobalStatus(before) && SessionStatusValidator.isTimeoutGlobalStatus(after)) {
            return false;
        }
        if (SessionStatusValidator.isRollbackGlobalStatus(before) && SessionStatusValidator.isCommitGlobalStatus(after)) {
            return false;
        }
        return !SessionStatusValidator.isCommitGlobalStatus(before) || !SessionStatusValidator.isRollbackGlobalStatus(after);
    }
}

