/*
 * Decompiled with CFR 0.152.
 */
package io.seata.saga.proctrl.impl;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.FrameworkException;
import io.seata.saga.proctrl.ProcessContext;
import io.seata.saga.proctrl.ProcessController;
import io.seata.saga.proctrl.process.BusinessProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessControllerImpl
implements ProcessController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessControllerImpl.class);
    private BusinessProcessor businessProcessor;

    @Override
    public void process(ProcessContext context) throws FrameworkException {
        try {
            this.businessProcessor.process(context);
            this.businessProcessor.route(context);
        }
        catch (FrameworkException fex) {
            throw fex;
        }
        catch (Exception ex) {
            LOGGER.error("Unknown exception occurred, context = {}", (Object)context, (Object)ex);
            throw new FrameworkException((Throwable)ex, "Unknown exception occurred", FrameworkErrorCode.UnknownAppError);
        }
    }

    public void setBusinessProcessor(BusinessProcessor businessProcessor) {
        this.businessProcessor = businessProcessor;
    }
}

