/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.datasource.exec;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.CollectionUtils;
import io.seata.core.context.RootContext;
import io.seata.core.model.BranchType;
import io.seata.rm.datasource.StatementProxy;
import io.seata.rm.datasource.exec.DeleteExecutor;
import io.seata.rm.datasource.exec.Executor;
import io.seata.rm.datasource.exec.InsertExecutor;
import io.seata.rm.datasource.exec.MultiExecutor;
import io.seata.rm.datasource.exec.PlainExecutor;
import io.seata.rm.datasource.exec.SelectForUpdateExecutor;
import io.seata.rm.datasource.exec.StatementCallback;
import io.seata.rm.datasource.exec.UpdateExecutor;
import io.seata.rm.datasource.exec.mysql.MySQLInsertOnDuplicateUpdateExecutor;
import io.seata.rm.datasource.exec.mysql.MySQLUpdateJoinExecutor;
import io.seata.rm.datasource.sql.SQLVisitorFactory;
import io.seata.sqlparser.SQLRecognizer;
import io.seata.sqlparser.SQLType;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ExecuteTemplate {
    public static <T, S extends Statement> T execute(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        return ExecuteTemplate.execute(null, statementProxy, statementCallback, args);
    }

    public static <T, S extends Statement> T execute(List<SQLRecognizer> sqlRecognizers, StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, Object ... args) throws SQLException {
        Object rs;
        Executor executor;
        if (!RootContext.requireGlobalLock() && BranchType.AT != RootContext.getBranchType()) {
            return statementCallback.execute(statementProxy.getTargetStatement(), args);
        }
        String dbType = statementProxy.getConnectionProxy().getDbType();
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            sqlRecognizers = SQLVisitorFactory.get(statementProxy.getTargetSQL(), dbType);
        }
        if (CollectionUtils.isEmpty(sqlRecognizers)) {
            executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
        } else if (sqlRecognizers.size() == 1) {
            SQLRecognizer sqlRecognizer = sqlRecognizers.get(0);
            block1 : switch (sqlRecognizer.getSQLType()) {
                case INSERT: {
                    executor = (Executor)EnhancedServiceLoader.load(InsertExecutor.class, (String)dbType, (Class[])new Class[]{StatementProxy.class, StatementCallback.class, SQLRecognizer.class}, (Object[])new Object[]{statementProxy, statementCallback, sqlRecognizer});
                    break;
                }
                case UPDATE: {
                    executor = new UpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case DELETE: {
                    executor = new DeleteExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case SELECT_FOR_UPDATE: {
                    executor = new SelectForUpdateExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                    break;
                }
                case INSERT_ON_DUPLICATE_UPDATE: {
                    switch (dbType) {
                        case "mysql": 
                        case "mariadb": {
                            executor = new MySQLInsertOnDuplicateUpdateExecutor((StatementProxy)statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                    }
                    throw new NotSupportYetException(dbType + " not support to INSERT_ON_DUPLICATE_UPDATE");
                }
                case UPDATE_JOIN: {
                    switch (dbType) {
                        case "mysql": {
                            executor = new MySQLUpdateJoinExecutor<T, S>(statementProxy, statementCallback, sqlRecognizer);
                            break block1;
                        }
                    }
                    throw new NotSupportYetException(dbType + " not support to " + SQLType.UPDATE_JOIN.name());
                }
                default: {
                    executor = new PlainExecutor<T, S>(statementProxy, statementCallback);
                }
            }
        } else {
            executor = new MultiExecutor<T, S>(statementProxy, statementCallback, sqlRecognizers);
        }
        try {
            rs = executor.execute(args);
        }
        catch (Throwable ex2) {
            SQLException ex2;
            if (!(ex2 instanceof SQLException)) {
                ex2 = new SQLException(ex2);
            }
            throw (SQLException)ex2;
        }
        return rs;
    }
}

