/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc.processor.server;

import io.seata.common.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLogHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchLogHandler.class);
    private static final BlockingQueue<String> LOG_QUEUE = new LinkedBlockingQueue<String>();
    public static final BatchLogHandler INSTANCE = new BatchLogHandler();
    private static final int MAX_LOG_SEND_THREAD = 1;
    private static final int MAX_LOG_TAKE_SIZE = 1024;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final String THREAD_PREFIX = "batchLoggerPrint";
    private static final long BUSY_SLEEP_MILLS = 5L;

    public BlockingQueue<String> getLogQueue() {
        return LOG_QUEUE;
    }

    static {
        ThreadPoolExecutor mergeSendExecutorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory(THREAD_PREFIX, 1, true));
        mergeSendExecutorService.submit(new BatchLogRunnable());
    }

    static class BatchLogRunnable
    implements Runnable {
        BatchLogRunnable() {
        }

        @Override
        public void run() {
            ArrayList<String> logList = new ArrayList<String>();
            while (true) {
                try {
                    while (true) {
                        logList.add((String)LOG_QUEUE.take());
                        LOG_QUEUE.drainTo(logList, 1024);
                        if (LOGGER.isInfoEnabled()) {
                            for (String str : logList) {
                                LOGGER.info(str);
                            }
                        }
                        logList.clear();
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
                catch (InterruptedException exx) {
                    LOGGER.error("batch log busy sleep error:{}", (Object)exx.getMessage(), (Object)exx);
                    continue;
                }
                break;
            }
        }
    }
}

