/*
 * Decompiled with CFR 0.152.
 */
package io.seata.rm.tcc;

import io.seata.common.exception.FrameworkErrorCode;
import io.seata.common.exception.SkipCallbackWrapperException;
import io.seata.common.executor.Callback;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.rm.tcc.TwoPhaseResult;
import io.seata.rm.tcc.exception.TCCFenceException;
import io.seata.rm.tcc.store.TCCFenceDO;
import io.seata.rm.tcc.store.TCCFenceStore;
import io.seata.rm.tcc.store.db.TCCFenceStoreDataBaseDAO;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

public class TCCFenceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCCFenceHandler.class);
    private static final TCCFenceStore TCC_FENCE_DAO = TCCFenceStoreDataBaseDAO.getInstance();
    private static DataSource dataSource;
    private static TransactionTemplate transactionTemplate;
    private static final int MAX_THREAD_CLEAN = 1;
    private static final int MAX_QUEUE_SIZE = 500;
    private static final int LIMIT_DELETE = 1000;
    private static final LinkedBlockingQueue<FenceLogIdentity> LOG_QUEUE;
    private static FenceLogCleanRunnable fenceLogCleanRunnable;
    private static ExecutorService logCleanExecutor;

    private TCCFenceHandler() {
        throw new IllegalStateException("Utility class");
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void setDataSource(DataSource dataSource) {
        TCCFenceHandler.dataSource = dataSource;
    }

    public static void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        TCCFenceHandler.transactionTemplate = transactionTemplate;
    }

    public static Object prepareFence(String xid, Long branchId, String actionName, Callback<Object> targetCallback) {
        return transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                boolean result = TCCFenceHandler.insertTCCFenceLog(conn, xid, branchId, actionName, 1);
                LOGGER.info("TCC fence prepare result: {}. xid: {}, branchId: {}", new Object[]{result, xid, branchId});
                if (result) {
                    return targetCallback.execute();
                }
                throw new TCCFenceException(String.format("Insert tcc fence record error, prepare fence failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.InsertRecordError);
            }
            catch (TCCFenceException e) {
                if (e.getErrcode() == FrameworkErrorCode.DuplicateKeyException) {
                    LOGGER.error("Branch transaction has already rollbacked before,prepare fence failed. xid= {},branchId = {}", (Object)xid, (Object)branchId);
                    TCCFenceHandler.addToLogCleanQueue(xid, branchId);
                }
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException((Throwable)((Object)e));
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    public static boolean commitFence(Method commitMethod, Object targetTCCBean, String xid, Long branchId, Object[] args) {
        return (Boolean)transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                TCCFenceDO tccFenceDO = TCC_FENCE_DAO.queryTCCFenceDO(conn, xid, branchId);
                if (tccFenceDO == null) {
                    throw new TCCFenceException(String.format("TCC fence record not exists, commit fence method failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.RecordNotExists);
                }
                if (2 == tccFenceDO.getStatus()) {
                    LOGGER.info("Branch transaction has already committed before. idempotency rejected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, tccFenceDO.getStatus()});
                    return true;
                }
                if (3 == tccFenceDO.getStatus() || 4 == tccFenceDO.getStatus()) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Branch transaction status is unexpected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, tccFenceDO.getStatus()});
                    }
                    return false;
                }
                return TCCFenceHandler.updateStatusAndInvokeTargetMethod(conn, commitMethod, targetTCCBean, xid, branchId, 2, status, args);
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    public static boolean rollbackFence(Method rollbackMethod, Object targetTCCBean, String xid, Long branchId, Object[] args, String actionName) {
        return (Boolean)transactionTemplate.execute(status -> {
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                TCCFenceDO tccFenceDO = TCC_FENCE_DAO.queryTCCFenceDO(conn, xid, branchId);
                if (tccFenceDO == null) {
                    boolean result = TCCFenceHandler.insertTCCFenceLog(conn, xid, branchId, actionName, 4);
                    LOGGER.info("Insert tcc fence record result: {}. xid: {}, branchId: {}", new Object[]{result, xid, branchId});
                    if (!result) {
                        throw new TCCFenceException(String.format("Insert tcc fence record error, rollback fence method failed. xid= %s, branchId= %s", xid, branchId), FrameworkErrorCode.InsertRecordError);
                    }
                    return true;
                }
                if (3 == tccFenceDO.getStatus() || 4 == tccFenceDO.getStatus()) {
                    LOGGER.info("Branch transaction had already rollbacked before, idempotency rejected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, tccFenceDO.getStatus()});
                    return true;
                }
                if (2 == tccFenceDO.getStatus()) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Branch transaction status is unexpected. xid: {}, branchId: {}, status: {}", new Object[]{xid, branchId, tccFenceDO.getStatus()});
                    }
                    return false;
                }
                return TCCFenceHandler.updateStatusAndInvokeTargetMethod(conn, rollbackMethod, targetTCCBean, xid, branchId, 3, status, args);
            }
            catch (Throwable t) {
                status.setRollbackOnly();
                throw new SkipCallbackWrapperException(t);
            }
        });
    }

    private static boolean insertTCCFenceLog(Connection conn, String xid, Long branchId, String actionName, Integer status) {
        TCCFenceDO tccFenceDO = new TCCFenceDO();
        tccFenceDO.setXid(xid);
        tccFenceDO.setBranchId(branchId);
        tccFenceDO.setActionName(actionName);
        tccFenceDO.setStatus(status);
        return TCC_FENCE_DAO.insertTCCFenceDO(conn, tccFenceDO);
    }

    private static boolean updateStatusAndInvokeTargetMethod(Connection conn, Method method, Object targetTCCBean, String xid, Long branchId, int status, TransactionStatus transactionStatus, Object[] args) throws Exception {
        Object ret;
        boolean result = TCC_FENCE_DAO.updateTCCFenceDO(conn, xid, branchId, status, 1);
        if (result && null != (ret = method.invoke(targetTCCBean, args)) && !(result = ret instanceof TwoPhaseResult ? ((TwoPhaseResult)ret).isSuccess() : ((Boolean)ret).booleanValue())) {
            transactionStatus.setRollbackOnly();
        }
        return result;
    }

    public static boolean deleteFence(String xid, Long branchId) {
        return (Boolean)transactionTemplate.execute(status -> {
            boolean ret = false;
            try {
                Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);
                ret = TCC_FENCE_DAO.deleteTCCFenceDO(conn, xid, branchId);
            }
            catch (RuntimeException e) {
                status.setRollbackOnly();
                LOGGER.error("delete fence log failed, xid: {}, branchId: {}", new Object[]{xid, branchId, e});
            }
            return ret;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteFenceByDate(Date datetime) {
        DataSource dataSource = TCCFenceHandler.getDataSource();
        Connection connection = null;
        int total = 0;
        try {
            Set<String> xidSet;
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            if (TCCFenceHandler.isOracle(connection)) {
                int n = TCC_FENCE_DAO.deleteTCCFenceDOByDate(connection, datetime);
                return n;
            }
            while (!(xidSet = TCC_FENCE_DAO.queryEndStatusXidsByDate(connection, datetime, 1000)).isEmpty()) {
                total += TCC_FENCE_DAO.deleteTCCFenceDO(connection, new ArrayList<String>(xidSet));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("delete fence log failed ", (Throwable)e);
        }
        finally {
            if (connection != null) {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
        }
        return total;
    }

    private static boolean isOracle(Connection connection) {
        try {
            String url = connection.getMetaData().getURL();
            return url.toLowerCase().contains(":oracle:");
        }
        catch (SQLException e) {
            LOGGER.error("get db type fail", (Throwable)e);
            return false;
        }
    }

    private static void initLogCleanExecutor() {
        logCleanExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fenceLogCleanThread", 1, true));
        fenceLogCleanRunnable = new FenceLogCleanRunnable();
        logCleanExecutor.submit(fenceLogCleanRunnable);
    }

    private static void addToLogCleanQueue(String xid, long branchId) {
        FenceLogIdentity logIdentity = new FenceLogIdentity();
        logIdentity.setXid(xid);
        logIdentity.setBranchId(branchId);
        try {
            LOG_QUEUE.add(logIdentity);
        }
        catch (Exception e) {
            LOGGER.warn("Insert tcc fence record into queue for async delete error,xid:{},branchId:{}", new Object[]{xid, branchId, e});
        }
    }

    static {
        LOG_QUEUE = new LinkedBlockingQueue(500);
        try {
            TCCFenceHandler.initLogCleanExecutor();
        }
        catch (Exception e) {
            LOGGER.error("init fence log clean executor error", (Throwable)e);
        }
    }

    private static class FenceLogCleanRunnable
    implements Runnable {
        private FenceLogCleanRunnable() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        FenceLogIdentity logIdentity;
                        boolean ret;
                        if (ret = TCCFenceHandler.deleteFence((logIdentity = (FenceLogIdentity)LOG_QUEUE.take()).getXid(), logIdentity.getBranchId())) {
                            continue;
                        }
                        LOGGER.error("delete fence log failed, xid: {}, branchId: {}", (Object)logIdentity.getXid(), (Object)logIdentity.getBranchId());
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.error("take fence log from queue for clean be interrupted", (Throwable)e);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("exception occur when clean fence log", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private static class FenceLogIdentity {
        private String xid;
        private Long branchId;

        private FenceLogIdentity() {
        }

        public String getXid() {
            return this.xid;
        }

        public Long getBranchId() {
            return this.branchId;
        }

        public void setXid(String xid) {
            this.xid = xid;
        }

        public void setBranchId(Long branchId) {
            this.branchId = branchId;
        }
    }
}

