/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.registry;

import io.seata.common.exception.NotSupportYetException;
import io.seata.common.loader.EnhancedServiceLoader;
import io.seata.common.util.StringUtils;
import io.seata.config.ConfigurationFactory;
import io.seata.discovery.registry.RegistryProvider;
import io.seata.discovery.registry.RegistryService;
import io.seata.discovery.registry.RegistryType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiRegistryFactory {
    public static List<RegistryService> getInstances() {
        return MultiRegistryFactoryHolder.INSTANCES;
    }

    private static List<RegistryService> buildRegistryServices() {
        String[] registryTypeNames;
        ArrayList<RegistryService> registryServices = new ArrayList<RegistryService>();
        String registryTypeNamesStr = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        if (StringUtils.isBlank(registryTypeNamesStr)) {
            registryTypeNamesStr = RegistryType.File.name();
        }
        for (String registryTypeName : registryTypeNames = registryTypeNamesStr.split(",")) {
            RegistryType registryType;
            try {
                registryType = RegistryType.getType(registryTypeName);
            }
            catch (Exception exx) {
                throw new NotSupportYetException("not support registry type: " + registryTypeName);
            }
            RegistryService registryService = EnhancedServiceLoader.load(RegistryProvider.class, Objects.requireNonNull(registryType).name()).provide();
            registryServices.add(registryService);
        }
        return registryServices;
    }

    static /* synthetic */ List access$100() {
        return MultiRegistryFactory.buildRegistryServices();
    }

    private static class MultiRegistryFactoryHolder {
        private static final List<RegistryService> INSTANCES = MultiRegistryFactory.access$100();

        private MultiRegistryFactoryHolder() {
        }
    }
}

