/*
 * Decompiled with CFR 0.152.
 */
package io.seata.server.storage.file.store;

import io.seata.common.exception.StoreException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.server.session.BranchSession;
import io.seata.server.session.GlobalSession;
import io.seata.server.session.SessionCondition;
import io.seata.server.session.SessionManager;
import io.seata.server.storage.file.FlushDiskMode;
import io.seata.server.storage.file.ReloadableStore;
import io.seata.server.storage.file.TransactionWriteStore;
import io.seata.server.store.AbstractTransactionStoreManager;
import io.seata.server.store.SessionStorable;
import io.seata.server.store.StoreConfig;
import io.seata.server.store.TransactionStoreManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class FileTransactionStoreManager
extends AbstractTransactionStoreManager
implements TransactionStoreManager,
ReloadableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTransactionStoreManager.class);
    private static final int MAX_THREAD_WRITE = 1;
    private ExecutorService fileWriteExecutor;
    private volatile boolean stopping = false;
    private static final int MAX_SHUTDOWN_RETRY = 3;
    private static final int SHUTDOWN_CHECK_INTERVAL = 1000;
    private static final int MAX_WRITE_RETRY = 5;
    private static final String HIS_DATA_FILENAME_POSTFIX = ".1";
    private static final AtomicLong FILE_TRX_NUM = new AtomicLong(0L);
    private static final AtomicLong FILE_FLUSH_NUM = new AtomicLong(0L);
    private static final int MARK_SIZE = 4;
    private static final int MAX_WAIT_TIME_MILLS = 2000;
    private static final int MAX_FLUSH_TIME_MILLS = 2000;
    private static final int MAX_FLUSH_NUM = 10;
    private static final int PER_FILE_BLOCK_SIZE = 524280;
    private static final long MAX_TRX_TIMEOUT_MILLS = 1800000L;
    private static volatile long trxStartTimeMills = System.currentTimeMillis();
    private File currDataFile;
    private RandomAccessFile currRaf;
    private FileChannel currFileChannel;
    private long recoverCurrOffset = 0L;
    private long recoverHisOffset = 0L;
    private SessionManager sessionManager;
    private String currFullFileName;
    private String hisFullFileName;
    private WriteDataFileRunnable writeDataFileRunnable;
    private ReentrantLock writeSessionLock = new ReentrantLock();
    private volatile long lastModifiedTime;
    private static final int MAX_WRITE_BUFFER_SIZE = StoreConfig.getFileWriteBufferCacheSize();
    private final ByteBuffer writeBuffer = ByteBuffer.allocateDirect(MAX_WRITE_BUFFER_SIZE);
    private static final FlushDiskMode FLUSH_DISK_MODE = StoreConfig.getFlushDiskMode();
    private static final int MAX_WAIT_FOR_FLUSH_TIME_MILLS = 2000;
    private static final int MAX_WAIT_FOR_CLOSE_TIME_MILLS = 2000;
    private static final int INT_BYTE_SIZE = 4;

    public FileTransactionStoreManager(String fullFileName, SessionManager sessionManager) throws IOException {
        this.initFile(fullFileName);
        this.fileWriteExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("fileTransactionStore", 1, true));
        this.writeDataFileRunnable = new WriteDataFileRunnable();
        this.fileWriteExecutor.submit(this.writeDataFileRunnable);
        this.sessionManager = sessionManager;
    }

    private void initFile(String fullFileName) throws IOException {
        this.currFullFileName = fullFileName;
        this.hisFullFileName = fullFileName + HIS_DATA_FILENAME_POSTFIX;
        try {
            this.currDataFile = new File(this.currFullFileName);
            if (!this.currDataFile.exists()) {
                if (this.currDataFile.getParentFile() != null && !this.currDataFile.getParentFile().exists()) {
                    this.currDataFile.getParentFile().mkdirs();
                }
                this.currDataFile.createNewFile();
                trxStartTimeMills = System.currentTimeMillis();
            } else {
                trxStartTimeMills = this.currDataFile.lastModified();
            }
            this.lastModifiedTime = System.currentTimeMillis();
            this.currRaf = new RandomAccessFile(this.currDataFile, "rw");
            this.currRaf.seek(this.currDataFile.length());
            this.currFileChannel = this.currRaf.getChannel();
        }
        catch (IOException exx) {
            LOGGER.error("init file error,{}", (Object)exx.getMessage(), (Object)exx);
            throw exx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeSession(TransactionStoreManager.LogOperation logOperation, SessionStorable session) {
        long curFileTrxNum;
        this.writeSessionLock.lock();
        try {
            if (!this.writeDataFile(new TransactionWriteStore(session, logOperation).encode())) {
                boolean bl = false;
                return bl;
            }
            this.lastModifiedTime = System.currentTimeMillis();
            curFileTrxNum = FILE_TRX_NUM.incrementAndGet();
            if (curFileTrxNum % 524280L == 0L && System.currentTimeMillis() - trxStartTimeMills > 1800000L) {
                boolean bl = this.saveHistory();
                return bl;
            }
        }
        catch (Exception exx) {
            LOGGER.error("writeSession error, {}", (Object)exx.getMessage(), (Object)exx);
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeSessionLock.unlock();
        }
        this.flushDisk(curFileTrxNum, this.currFileChannel);
        return true;
    }

    private void flushDisk(long curFileNum, FileChannel currFileChannel) {
        if (FLUSH_DISK_MODE == FlushDiskMode.SYNC_MODEL) {
            SyncFlushRequest syncFlushRequest = new SyncFlushRequest(curFileNum, currFileChannel);
            this.writeDataFileRunnable.putRequest(syncFlushRequest);
            syncFlushRequest.waitForFlush(2000L);
        } else {
            this.writeDataFileRunnable.putRequest(new AsyncFlushRequest(curFileNum, currFileChannel));
        }
    }

    private boolean saveHistory() throws IOException {
        boolean result;
        try {
            result = this.findTimeoutAndSave();
            CloseFileRequest request = new CloseFileRequest(this.currFileChannel, this.currRaf);
            this.writeDataFileRunnable.putRequest(request);
            request.waitForClose(2000L);
            Files.move(this.currDataFile.toPath(), new File(this.hisFullFileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException exx) {
            LOGGER.error("save history data file error, {}", (Object)exx.getMessage(), (Object)exx);
            result = false;
        }
        finally {
            this.initFile(this.currFullFileName);
        }
        return result;
    }

    private boolean writeDataFrame(byte[] data) {
        int dataLengthToWrite;
        if (data == null || data.length <= 0) {
            return true;
        }
        int dataLength = data.length;
        int bufferRemainingSize = this.writeBuffer.remaining();
        if (bufferRemainingSize <= 4 && !this.flushWriteBuffer(this.writeBuffer)) {
            return false;
        }
        bufferRemainingSize = this.writeBuffer.remaining();
        if (bufferRemainingSize <= 4) {
            throw new IllegalStateException(String.format("Write buffer remaining size %d was too small", bufferRemainingSize));
        }
        this.writeBuffer.putInt(dataLength);
        bufferRemainingSize = this.writeBuffer.remaining();
        for (int dataPos = 0; dataPos < dataLength; dataPos += dataLengthToWrite) {
            dataLengthToWrite = dataLength - dataPos;
            dataLengthToWrite = Math.min(dataLengthToWrite, bufferRemainingSize);
            this.writeBuffer.put(data, dataPos, dataLengthToWrite);
            bufferRemainingSize = this.writeBuffer.remaining();
            if (bufferRemainingSize != 0) continue;
            if (!this.flushWriteBuffer(this.writeBuffer)) {
                return false;
            }
            bufferRemainingSize = this.writeBuffer.remaining();
        }
        return true;
    }

    private boolean flushWriteBuffer(ByteBuffer writeBuffer) {
        writeBuffer.flip();
        if (!this.writeDataFileByBuffer(writeBuffer)) {
            return false;
        }
        writeBuffer.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findTimeoutAndSave() throws IOException {
        List<GlobalSession> globalSessionsOverMaxTimeout = this.sessionManager.findGlobalSessions(new SessionCondition(1800000L));
        if (CollectionUtils.isEmpty(globalSessionsOverMaxTimeout)) {
            return true;
        }
        for (GlobalSession globalSession : globalSessionsOverMaxTimeout) {
            TransactionWriteStore globalWriteStore = new TransactionWriteStore(globalSession, TransactionStoreManager.LogOperation.GLOBAL_ADD);
            byte[] data = globalWriteStore.encode();
            if (!this.writeDataFrame(data)) {
                return false;
            }
            List<BranchSession> branchSessIonsOverMaXTimeout = globalSession.getSortedBranches();
            if (branchSessIonsOverMaXTimeout == null) continue;
            for (BranchSession branchSession : branchSessIonsOverMaXTimeout) {
                try {
                    MDC.put((String)"X-TX-BRANCH-ID", (String)String.valueOf(branchSession.getBranchId()));
                    TransactionWriteStore branchWriteStore = new TransactionWriteStore(branchSession, TransactionStoreManager.LogOperation.BRANCH_ADD);
                    data = branchWriteStore.encode();
                    if (this.writeDataFrame(data)) continue;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    MDC.remove((String)"X-TX-BRANCH-ID");
                }
            }
        }
        if (this.flushWriteBuffer(this.writeBuffer)) {
            this.currFileChannel.force(false);
            return true;
        }
        return false;
    }

    @Override
    public GlobalSession readSession(String xid) {
        throw new StoreException("unsupport for read from file, xid:" + xid);
    }

    @Override
    public List<GlobalSession> readSession(SessionCondition sessionCondition) {
        throw new StoreException("unsupport for read from file");
    }

    @Override
    public void shutdown() {
        if (this.fileWriteExecutor != null) {
            this.fileWriteExecutor.shutdown();
            this.stopping = true;
            int retry = 0;
            while (!this.fileWriteExecutor.isTerminated() && retry < 3) {
                ++retry;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (retry >= 3) {
                this.fileWriteExecutor.shutdownNow();
            }
        }
        try {
            if (this.currFileChannel.isOpen()) {
                this.currFileChannel.force(true);
            }
        }
        catch (IOException e) {
            LOGGER.error("fileChannel force error: {}", (Object)e.getMessage(), (Object)e);
        }
        this.closeFile(this.currRaf);
    }

    @Override
    public List<TransactionWriteStore> readWriteStore(int readSize, boolean isHistory) {
        File file = null;
        long currentOffset = 0L;
        if (isHistory) {
            file = new File(this.hisFullFileName);
            currentOffset = this.recoverHisOffset;
        } else {
            file = new File(this.currFullFileName);
            currentOffset = this.recoverCurrOffset;
        }
        if (file.exists()) {
            return this.parseDataFile(file, readSize, currentOffset, isHistory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean hasRemaining(boolean isHistory) {
        long currentOffset;
        File file;
        RandomAccessFile raf = null;
        if (isHistory) {
            file = new File(this.hisFullFileName);
            currentOffset = this.recoverHisOffset;
        } else {
            file = new File(this.currFullFileName);
            currentOffset = this.recoverCurrOffset;
        }
        try {
            raf = new RandomAccessFile(file, "r");
            boolean bl = currentOffset < raf.length();
            this.closeFile(raf);
            return bl;
        }
        catch (IOException iOException) {
            this.closeFile(raf);
            catch (Throwable throwable) {
                this.closeFile(raf);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TransactionWriteStore> parseDataFile(File file, int readSize, long currentOffset, boolean isHistory) {
        ArrayList<TransactionWriteStore> transactionWriteStores = new ArrayList<TransactionWriteStore>(readSize);
        RandomAccessFile raf = null;
        FileChannel fileChannel = null;
        try {
            raf = new RandomAccessFile(file, "r");
            raf.seek(currentOffset);
            fileChannel = raf.getChannel();
            fileChannel.position(currentOffset);
            long size = raf.length();
            ByteBuffer buffSize = ByteBuffer.allocate(4);
            while (fileChannel.position() < size) {
                try {
                    buffSize.clear();
                    int avilReadSize = fileChannel.read(buffSize);
                    if (avilReadSize != 4) break;
                    buffSize.flip();
                    int bodySize = buffSize.getInt();
                    byte[] byBody = new byte[bodySize];
                    ByteBuffer buffBody = ByteBuffer.wrap(byBody);
                    avilReadSize = fileChannel.read(buffBody);
                    if (avilReadSize != bodySize) break;
                    TransactionWriteStore writeStore = new TransactionWriteStore();
                    writeStore.decode(byBody);
                    transactionWriteStores.add(writeStore);
                    if (transactionWriteStores.size() != readSize) continue;
                    break;
                }
                catch (Exception ex) {
                    LOGGER.error("decode data file error:{}", (Object)ex.getMessage(), (Object)ex);
                    break;
                }
            }
            ArrayList<TransactionWriteStore> arrayList = transactionWriteStores;
            return arrayList;
        }
        catch (IOException exx) {
            LOGGER.error("parse data file error:{},file:{}", new Object[]{exx.getMessage(), file.getName(), exx});
            List<TransactionWriteStore> list = null;
            return list;
        }
        finally {
            try {
                if (fileChannel != null) {
                    if (isHistory) {
                        this.recoverHisOffset = fileChannel.position();
                    } else {
                        this.recoverCurrOffset = fileChannel.position();
                    }
                }
                this.closeFile(raf);
            }
            catch (IOException exx) {
                LOGGER.error("file close error{}", (Object)exx.getMessage(), (Object)exx);
            }
        }
    }

    private void closeFile(RandomAccessFile raf) {
        try {
            if (raf != null) {
                raf.close();
                raf = null;
            }
        }
        catch (IOException exx) {
            LOGGER.error("file close error,{}", (Object)exx.getMessage(), (Object)exx);
        }
    }

    private boolean writeDataFile(byte[] bs) {
        if (bs == null || bs.length >= 0x7FFFFFFC) {
            return false;
        }
        if (!this.writeDataFrame(bs)) {
            return false;
        }
        return this.flushWriteBuffer(this.writeBuffer);
    }

    private boolean writeDataFileByBuffer(ByteBuffer byteBuffer) {
        for (int retry = 0; retry < 5; ++retry) {
            try {
                while (byteBuffer.hasRemaining()) {
                    this.currFileChannel.write(byteBuffer);
                }
                return true;
            }
            catch (Exception exx) {
                LOGGER.error("write data file error:{}", (Object)exx.getMessage(), (Object)exx);
                continue;
            }
        }
        LOGGER.error("write dataFile failed,retry more than :{}", (Object)5);
        return false;
    }

    class WriteDataFileRunnable
    implements Runnable {
        private LinkedBlockingQueue<StoreRequest> storeRequests = new LinkedBlockingQueue();

        WriteDataFileRunnable() {
        }

        public void putRequest(StoreRequest request) {
            this.storeRequests.add(request);
        }

        @Override
        public void run() {
            while (!FileTransactionStoreManager.this.stopping) {
                try {
                    StoreRequest storeRequest = this.storeRequests.poll(2000L, TimeUnit.MILLISECONDS);
                    this.handleStoreRequest(storeRequest);
                }
                catch (Exception exx) {
                    LOGGER.error("write file error: {}", (Object)exx.getMessage(), (Object)exx);
                }
            }
            this.handleRestRequest();
        }

        private void handleRestRequest() {
            int remainNums = this.storeRequests.size();
            for (int i = 0; i < remainNums; ++i) {
                this.handleStoreRequest(this.storeRequests.poll());
            }
        }

        private void handleStoreRequest(StoreRequest storeRequest) {
            if (storeRequest == null) {
                this.flushOnCondition(FileTransactionStoreManager.this.currFileChannel);
            }
            if (storeRequest instanceof SyncFlushRequest) {
                this.syncFlush((SyncFlushRequest)storeRequest);
            } else if (storeRequest instanceof AsyncFlushRequest) {
                this.async((AsyncFlushRequest)storeRequest);
            } else if (storeRequest instanceof CloseFileRequest) {
                this.closeAndFlush((CloseFileRequest)storeRequest);
            }
        }

        private void closeAndFlush(CloseFileRequest req) {
            long diff = FILE_TRX_NUM.get() - FILE_FLUSH_NUM.get();
            this.flush(req.getFileChannel());
            FILE_FLUSH_NUM.addAndGet(diff);
            FileTransactionStoreManager.this.closeFile(req.getFile());
            req.wakeup();
        }

        private void async(AsyncFlushRequest req) {
            this.flushOnCondition(req.getCurFileChannel());
        }

        private void syncFlush(SyncFlushRequest req) {
            if (req.getCurFileTrxNum() > FILE_FLUSH_NUM.get()) {
                long diff = FILE_TRX_NUM.get() - FILE_FLUSH_NUM.get();
                this.flush(req.getCurFileChannel());
                FILE_FLUSH_NUM.addAndGet(diff);
            }
            req.wakeup();
        }

        private void flushOnCondition(FileChannel fileChannel) {
            if (FLUSH_DISK_MODE == FlushDiskMode.SYNC_MODEL) {
                return;
            }
            long diff = FILE_TRX_NUM.get() - FILE_FLUSH_NUM.get();
            if (diff == 0L) {
                return;
            }
            if (diff % 10L == 0L || System.currentTimeMillis() - FileTransactionStoreManager.this.lastModifiedTime > 2000L) {
                this.flush(fileChannel);
                FILE_FLUSH_NUM.addAndGet(diff);
            }
        }

        private void flush(FileChannel fileChannel) {
            try {
                fileChannel.force(false);
            }
            catch (IOException exx) {
                LOGGER.error("flush error: {}", (Object)exx.getMessage(), (Object)exx);
            }
        }
    }

    class SyncFlushRequest
    extends AbstractFlushRequest {
        private final CountDownLatch countDownLatch;

        public SyncFlushRequest(long curFileTrxNum, FileChannel curFileChannel) {
            super(curFileTrxNum, curFileChannel);
            this.countDownLatch = new CountDownLatch(1);
        }

        public void wakeup() {
            this.countDownLatch.countDown();
        }

        public void waitForFlush(long timeout) {
            try {
                this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", (Throwable)e);
            }
        }
    }

    static interface StoreRequest {
    }

    class AsyncFlushRequest
    extends AbstractFlushRequest {
        public AsyncFlushRequest(long curFileTrxNum, FileChannel curFileChannel) {
            super(curFileTrxNum, curFileChannel);
        }
    }

    static class CloseFileRequest
    implements StoreRequest {
        private final CountDownLatch countDownLatch = new CountDownLatch(1);
        private FileChannel fileChannel;
        private RandomAccessFile file;

        public CloseFileRequest(FileChannel fileChannel, RandomAccessFile file) {
            this.fileChannel = fileChannel;
            this.file = file;
        }

        public FileChannel getFileChannel() {
            return this.fileChannel;
        }

        public RandomAccessFile getFile() {
            return this.file;
        }

        public void wakeup() {
            this.countDownLatch.countDown();
        }

        public void waitForClose(long timeout) {
            try {
                this.countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted", (Throwable)e);
            }
        }
    }

    static abstract class AbstractFlushRequest
    implements StoreRequest {
        private final long curFileTrxNum;
        private final FileChannel curFileChannel;

        protected AbstractFlushRequest(long curFileTrxNum, FileChannel curFileChannel) {
            this.curFileTrxNum = curFileTrxNum;
            this.curFileChannel = curFileChannel;
        }

        public long getCurFileTrxNum() {
            return this.curFileTrxNum;
        }

        public FileChannel getCurFileChannel() {
            return this.curFileChannel;
        }
    }
}

